@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.SkuSettingCapacityArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.SkuScaleType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property default
 * @property maximum
 * @property minimum
 * @property scaleType
 */
public data class SkuSettingCapacityArgs(
    public val default: Output<Int>? = null,
    public val maximum: Output<Int>? = null,
    public val minimum: Output<Int>,
    public val scaleType: Output<Either<String, SkuScaleType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.SkuSettingCapacityArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.SkuSettingCapacityArgs =
        com.pulumi.azurenative.providerhub.inputs.SkuSettingCapacityArgs.builder()
            .default_(default?.applyValue({ args0 -> args0 }))
            .maximum(maximum?.applyValue({ args0 -> args0 }))
            .minimum(minimum.applyValue({ args0 -> args0 }))
            .scaleType(
                scaleType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuSettingCapacityArgs].
 */
@PulumiTagMarker
public class SkuSettingCapacityArgsBuilder internal constructor() {
    private var default: Output<Int>? = null

    private var maximum: Output<Int>? = null

    private var minimum: Output<Int>? = null

    private var scaleType: Output<Either<String, SkuScaleType>>? = null

    /**
     * @param value
     */
    @JvmName("wmlavugnlxhtlord")
    public suspend fun default(`value`: Output<Int>) {
        this.default = value
    }

    /**
     * @param value
     */
    @JvmName("uglbqcjgfoyshind")
    public suspend fun maximum(`value`: Output<Int>) {
        this.maximum = value
    }

    /**
     * @param value
     */
    @JvmName("wlgetdggjhwqoxbn")
    public suspend fun minimum(`value`: Output<Int>) {
        this.minimum = value
    }

    /**
     * @param value
     */
    @JvmName("fbjbvancsrvgvegp")
    public suspend fun scaleType(`value`: Output<Either<String, SkuScaleType>>) {
        this.scaleType = value
    }

    /**
     * @param value
     */
    @JvmName("vqdcdsgcgebwfarv")
    public suspend fun default(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value
     */
    @JvmName("puwqafbbmfowkshv")
    public suspend fun maximum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximum = mapped
    }

    /**
     * @param value
     */
    @JvmName("vywndnpngbiehhel")
    public suspend fun minimum(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimum = mapped
    }

    /**
     * @param value
     */
    @JvmName("ryldqqpbxjpnmbqq")
    public suspend fun scaleType(`value`: Either<String, SkuScaleType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleType = mapped
    }

    /**
     * @param value
     */
    @JvmName("ncdetqfwaiymqgqb")
    public fun scaleType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuScaleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleType = mapped
    }

    /**
     * @param value
     */
    @JvmName("ocypytrywodeixim")
    public fun scaleType(`value`: SkuScaleType) {
        val toBeMapped = Either.ofRight<String, SkuScaleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleType = mapped
    }

    internal fun build(): SkuSettingCapacityArgs = SkuSettingCapacityArgs(
        default = default,
        maximum = maximum,
        minimum = minimum ?: throw PulumiNullFieldException("minimum"),
        scaleType = scaleType,
    )
}
