@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.SkuZoneDetailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property capabilities
 * @property name
 */
public data class SkuZoneDetailArgs(
    public val capabilities: Output<List<SkuCapabilityArgs>>? = null,
    public val name: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.SkuZoneDetailArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.SkuZoneDetailArgs =
        com.pulumi.azurenative.providerhub.inputs.SkuZoneDetailArgs.builder()
            .capabilities(
                capabilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SkuZoneDetailArgs].
 */
@PulumiTagMarker
public class SkuZoneDetailArgsBuilder internal constructor() {
    private var capabilities: Output<List<SkuCapabilityArgs>>? = null

    private var name: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("imowkhvookxydame")
    public suspend fun capabilities(`value`: Output<List<SkuCapabilityArgs>>) {
        this.capabilities = value
    }

    @JvmName("nkgjsjokaeivknoo")
    public suspend fun capabilities(vararg values: Output<SkuCapabilityArgs>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("pfjaptirmjaekade")
    public suspend fun capabilities(values: List<Output<SkuCapabilityArgs>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("iuqgoqmlviynovgl")
    public suspend fun name(`value`: Output<List<String>>) {
        this.name = value
    }

    @JvmName("csgunaayvfyvepft")
    public suspend fun name(vararg values: Output<String>) {
        this.name = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("terasocbmmatljlx")
    public suspend fun name(values: List<Output<String>>) {
        this.name = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("piilxoloenlwsvgc")
    public suspend fun capabilities(`value`: List<SkuCapabilityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("flwtdakabiatngvk")
    public suspend fun capabilities(argument: List<suspend SkuCapabilityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SkuCapabilityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ojfenabfrdkiqqgx")
    public suspend fun capabilities(vararg argument: suspend SkuCapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SkuCapabilityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hytpomaojjltmotg")
    public suspend fun capabilities(argument: suspend SkuCapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SkuCapabilityArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param values
     */
    @JvmName("bhjapgytviaixjmf")
    public suspend fun capabilities(vararg values: SkuCapabilityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value
     */
    @JvmName("gbsbnfmtajkltryx")
    public suspend fun name(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param values
     */
    @JvmName("ytwakdexaebdrwng")
    public suspend fun name(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuZoneDetailArgs = SkuZoneDetailArgs(
        capabilities = capabilities,
        name = name,
    )
}
