@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.SubscriptionStateRuleArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.SubscriptionState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedActions
 * @property state
 */
public data class SubscriptionStateRuleArgs(
    public val allowedActions: Output<List<String>>? = null,
    public val state: Output<Either<String, SubscriptionState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.SubscriptionStateRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.SubscriptionStateRuleArgs =
        com.pulumi.azurenative.providerhub.inputs.SubscriptionStateRuleArgs.builder()
            .allowedActions(allowedActions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SubscriptionStateRuleArgs].
 */
@PulumiTagMarker
public class SubscriptionStateRuleArgsBuilder internal constructor() {
    private var allowedActions: Output<List<String>>? = null

    private var state: Output<Either<String, SubscriptionState>>? = null

    /**
     * @param value
     */
    @JvmName("firtfofkomjevxdu")
    public suspend fun allowedActions(`value`: Output<List<String>>) {
        this.allowedActions = value
    }

    @JvmName("qndlfktfddixfnyp")
    public suspend fun allowedActions(vararg values: Output<String>) {
        this.allowedActions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("cgwmwhqutkxbysed")
    public suspend fun allowedActions(values: List<Output<String>>) {
        this.allowedActions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("tnpelhcmjuhtvlqj")
    public suspend fun state(`value`: Output<Either<String, SubscriptionState>>) {
        this.state = value
    }

    /**
     * @param value
     */
    @JvmName("xilaycapcsxfdgno")
    public suspend fun allowedActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedActions = mapped
    }

    /**
     * @param values
     */
    @JvmName("igxwgolymhqilrls")
    public suspend fun allowedActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedActions = mapped
    }

    /**
     * @param value
     */
    @JvmName("cguwmhlqsovpaevp")
    public suspend fun state(`value`: Either<String, SubscriptionState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value
     */
    @JvmName("cprvabjsmjdvjebw")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SubscriptionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value
     */
    @JvmName("jerbxwelxfufcbpo")
    public fun state(`value`: SubscriptionState) {
        val toBeMapped = Either.ofRight<String, SubscriptionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): SubscriptionStateRuleArgs = SubscriptionStateRuleArgs(
        allowedActions = allowedActions,
        state = state,
    )
}
