@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ThrottlingMetricArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.ThrottlingMetricType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property interval
 * @property limit
 * @property type
 */
public data class ThrottlingMetricArgs(
    public val interval: Output<String>? = null,
    public val limit: Output<Double>,
    public val type: Output<Either<String, ThrottlingMetricType>>,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ThrottlingMetricArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ThrottlingMetricArgs =
        com.pulumi.azurenative.providerhub.inputs.ThrottlingMetricArgs.builder()
            .interval(interval?.applyValue({ args0 -> args0 }))
            .limit(limit.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ThrottlingMetricArgs].
 */
@PulumiTagMarker
public class ThrottlingMetricArgsBuilder internal constructor() {
    private var interval: Output<String>? = null

    private var limit: Output<Double>? = null

    private var type: Output<Either<String, ThrottlingMetricType>>? = null

    /**
     * @param value
     */
    @JvmName("ekuylnlwqovkckwx")
    public suspend fun interval(`value`: Output<String>) {
        this.interval = value
    }

    /**
     * @param value
     */
    @JvmName("ytwitisyacsakqkb")
    public suspend fun limit(`value`: Output<Double>) {
        this.limit = value
    }

    /**
     * @param value
     */
    @JvmName("yjbnaloufdrcugyj")
    public suspend fun type(`value`: Output<Either<String, ThrottlingMetricType>>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("wunymdtouvmrmfxc")
    public suspend fun interval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value
     */
    @JvmName("rmipytgrtlugwhjt")
    public suspend fun limit(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limit = mapped
    }

    /**
     * @param value
     */
    @JvmName("rmmdgbbemvlwnirw")
    public suspend fun type(`value`: Either<String, ThrottlingMetricType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("bevqcyyciytoxxnp")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ThrottlingMetricType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("yntgcdhojocoqkca")
    public fun type(`value`: ThrottlingMetricType) {
        val toBeMapped = Either.ofRight<String, ThrottlingMetricType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ThrottlingMetricArgs = ThrottlingMetricArgs(
        interval = interval,
        limit = limit ?: throw PulumiNullFieldException("limit"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
