@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ThrottlingRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property action
 * @property metrics
 * @property requiredFeatures
 */
public data class ThrottlingRuleArgs(
    public val action: Output<String>,
    public val metrics: Output<List<ThrottlingMetricArgs>>,
    public val requiredFeatures: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ThrottlingRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ThrottlingRuleArgs =
        com.pulumi.azurenative.providerhub.inputs.ThrottlingRuleArgs.builder()
            .action(action.applyValue({ args0 -> args0 }))
            .metrics(
                metrics.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .requiredFeatures(requiredFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ThrottlingRuleArgs].
 */
@PulumiTagMarker
public class ThrottlingRuleArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var metrics: Output<List<ThrottlingMetricArgs>>? = null

    private var requiredFeatures: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("xoccillsmtcmsrbv")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value
     */
    @JvmName("ksyhyasclvlmexnx")
    public suspend fun metrics(`value`: Output<List<ThrottlingMetricArgs>>) {
        this.metrics = value
    }

    @JvmName("ldkqaswvlkcoypmh")
    public suspend fun metrics(vararg values: Output<ThrottlingMetricArgs>) {
        this.metrics = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("csbwtaaljycgkqgd")
    public suspend fun metrics(values: List<Output<ThrottlingMetricArgs>>) {
        this.metrics = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("toueljewbeyewdsv")
    public suspend fun requiredFeatures(`value`: Output<List<String>>) {
        this.requiredFeatures = value
    }

    @JvmName("flbqrjnugacgthfs")
    public suspend fun requiredFeatures(vararg values: Output<String>) {
        this.requiredFeatures = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("pkipxsanposjcjxq")
    public suspend fun requiredFeatures(values: List<Output<String>>) {
        this.requiredFeatures = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("sobvxwvfvlspejgp")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value
     */
    @JvmName("ljfijwqgebordbbv")
    public suspend fun metrics(`value`: List<ThrottlingMetricArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rcdjxurrsshbnqgb")
    public suspend fun metrics(argument: List<suspend ThrottlingMetricArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ThrottlingMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dkbvurxbvwpanmco")
    public suspend fun metrics(vararg argument: suspend ThrottlingMetricArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ThrottlingMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("koccjklerurxdqqt")
    public suspend fun metrics(argument: suspend ThrottlingMetricArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ThrottlingMetricArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param values
     */
    @JvmName("fcpoqfnqtrqhrkxt")
    public suspend fun metrics(vararg values: ThrottlingMetricArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param value
     */
    @JvmName("ndetccprgajjtbyn")
    public suspend fun requiredFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param values
     */
    @JvmName("yhbqewsbdhneslpt")
    public suspend fun requiredFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    internal fun build(): ThrottlingRuleArgs = ThrottlingRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        metrics = metrics ?: throw PulumiNullFieldException("metrics"),
        requiredFeatures = requiredFeatures,
    )
}
