@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property allowedUnauthorizedActions
 * @property authorizationActionMappings
 * @property checkNameAvailabilitySpecifications
 * @property defaultApiVersion
 * @property disallowedActionVerbs
 * @property enableAsyncOperation
 * @property enableThirdPartyS2S
 * @property endpoints
 * @property extendedLocations
 * @property extensionOptions
 * @property featuresRule
 * @property identityManagement
 * @property isPureProxy
 * @property linkedAccessChecks
 * @property loggingRules
 * @property management
 * @property marketplaceType
 * @property openApiConfiguration
 * @property provisioningState The provisioned state of the resource.
 * @property regionality
 * @property requestHeaderOptions
 * @property requiredFeatures
 * @property resourceConcurrencyControlOptions
 * @property resourceDeletionPolicy
 * @property resourceGraphConfiguration
 * @property resourceMovePolicy
 * @property routingType
 * @property serviceTreeInfos
 * @property subscriptionLifecycleNotificationSpecifications
 * @property subscriptionStateRules
 * @property swaggerSpecifications
 * @property templateDeploymentOptions
 * @property throttlingRules
 */
public data class ResourceTypeRegistrationResponseProperties(
    public val allowedUnauthorizedActions: List<String>? = null,
    public val authorizationActionMappings: List<AuthorizationActionMappingResponse>? = null,
    public val checkNameAvailabilitySpecifications:
    ResourceTypeRegistrationPropertiesResponseCheckNameAvailabilitySpecifications? = null,
    public val defaultApiVersion: String? = null,
    public val disallowedActionVerbs: List<String>? = null,
    public val enableAsyncOperation: Boolean? = null,
    public val enableThirdPartyS2S: Boolean? = null,
    public val endpoints: List<ResourceTypeEndpointResponse>? = null,
    public val extendedLocations: List<ExtendedLocationOptionsResponse>? = null,
    public val extensionOptions: ResourceTypeRegistrationPropertiesResponseExtensionOptions? = null,
    public val featuresRule: ResourceTypeRegistrationPropertiesResponseFeaturesRule? = null,
    public val identityManagement: ResourceTypeRegistrationPropertiesResponseIdentityManagement? =
        null,
    public val isPureProxy: Boolean? = null,
    public val linkedAccessChecks: List<LinkedAccessCheckResponse>? = null,
    public val loggingRules: List<LoggingRuleResponse>? = null,
    public val management: ResourceTypeRegistrationPropertiesResponseManagement? = null,
    public val marketplaceType: String? = null,
    public val openApiConfiguration: OpenApiConfigurationResponse? = null,
    public val provisioningState: String? = null,
    public val regionality: String? = null,
    public val requestHeaderOptions: ResourceTypeRegistrationPropertiesResponseRequestHeaderOptions? =
        null,
    public val requiredFeatures: List<String>? = null,
    public val resourceConcurrencyControlOptions:
    Map<String, ResourceConcurrencyControlOptionResponse>? = null,
    public val resourceDeletionPolicy: String? = null,
    public val resourceGraphConfiguration:
    ResourceTypeRegistrationPropertiesResponseResourceGraphConfiguration? = null,
    public val resourceMovePolicy: ResourceTypeRegistrationPropertiesResponseResourceMovePolicy? =
        null,
    public val routingType: String? = null,
    public val serviceTreeInfos: List<ServiceTreeInfoResponse>? = null,
    public val subscriptionLifecycleNotificationSpecifications:
    ResourceTypeRegistrationPropertiesResponseSubscriptionLifecycleNotificationSpecifications? =
        null,
    public val subscriptionStateRules: List<SubscriptionStateRuleResponse>? = null,
    public val swaggerSpecifications: List<SwaggerSpecificationResponse>? = null,
    public val templateDeploymentOptions:
    ResourceTypeRegistrationPropertiesResponseTemplateDeploymentOptions? = null,
    public val throttlingRules: List<ThrottlingRuleResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.ResourceTypeRegistrationResponseProperties):
            ResourceTypeRegistrationResponseProperties = ResourceTypeRegistrationResponseProperties(
            allowedUnauthorizedActions = javaType.allowedUnauthorizedActions().map({ args0 -> args0 }),
            authorizationActionMappings = javaType.authorizationActionMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.AuthorizationActionMappingResponse.Companion.toKotlin(args0)
                })
            }),
            checkNameAvailabilitySpecifications = javaType.checkNameAvailabilitySpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationPropertiesResponseCheckNameAvailabilitySpecifications.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultApiVersion = javaType.defaultApiVersion().map({ args0 -> args0 }).orElse(null),
            disallowedActionVerbs = javaType.disallowedActionVerbs().map({ args0 -> args0 }),
            enableAsyncOperation = javaType.enableAsyncOperation().map({ args0 -> args0 }).orElse(null),
            enableThirdPartyS2S = javaType.enableThirdPartyS2S().map({ args0 -> args0 }).orElse(null),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            extendedLocations = javaType.extendedLocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ExtendedLocationOptionsResponse.Companion.toKotlin(args0)
                })
            }),
            extensionOptions = javaType.extensionOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationPropertiesResponseExtensionOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            featuresRule = javaType.featuresRule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationPropertiesResponseFeaturesRule.Companion.toKotlin(args0)
                })
            }).orElse(null),
            identityManagement = javaType.identityManagement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationPropertiesResponseIdentityManagement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isPureProxy = javaType.isPureProxy().map({ args0 -> args0 }).orElse(null),
            linkedAccessChecks = javaType.linkedAccessChecks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.LinkedAccessCheckResponse.Companion.toKotlin(args0)
                })
            }),
            loggingRules = javaType.loggingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.LoggingRuleResponse.Companion.toKotlin(args0)
                })
            }),
            management = javaType.management().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationPropertiesResponseManagement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            marketplaceType = javaType.marketplaceType().map({ args0 -> args0 }).orElse(null),
            openApiConfiguration = javaType.openApiConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.OpenApiConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            regionality = javaType.regionality().map({ args0 -> args0 }).orElse(null),
            requestHeaderOptions = javaType.requestHeaderOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationPropertiesResponseRequestHeaderOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requiredFeatures = javaType.requiredFeatures().map({ args0 -> args0 }),
            resourceConcurrencyControlOptions = javaType.resourceConcurrencyControlOptions().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceConcurrencyControlOptionResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            resourceDeletionPolicy = javaType.resourceDeletionPolicy().map({ args0 -> args0 }).orElse(null),
            resourceGraphConfiguration = javaType.resourceGraphConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationPropertiesResponseResourceGraphConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resourceMovePolicy = javaType.resourceMovePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationPropertiesResponseResourceMovePolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            routingType = javaType.routingType().map({ args0 -> args0 }).orElse(null),
            serviceTreeInfos = javaType.serviceTreeInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ServiceTreeInfoResponse.Companion.toKotlin(args0)
                })
            }),
            subscriptionLifecycleNotificationSpecifications = javaType.subscriptionLifecycleNotificationSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationPropertiesResponseSubscriptionLifecycleNotificationSpecifications.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subscriptionStateRules = javaType.subscriptionStateRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.SubscriptionStateRuleResponse.Companion.toKotlin(args0)
                })
            }),
            swaggerSpecifications = javaType.swaggerSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.SwaggerSpecificationResponse.Companion.toKotlin(args0)
                })
            }),
            templateDeploymentOptions = javaType.templateDeploymentOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationPropertiesResponseTemplateDeploymentOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            throttlingRules = javaType.throttlingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ThrottlingRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
