@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property apiVersions
 * @property swaggerSpecFolderUri
 */
public data class SwaggerSpecificationResponse(
    public val apiVersions: List<String>? = null,
    public val swaggerSpecFolderUri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.SwaggerSpecificationResponse):
            SwaggerSpecificationResponse = SwaggerSpecificationResponse(
            apiVersions = javaType.apiVersions().map({ args0 -> args0 }),
            swaggerSpecFolderUri = javaType.swaggerSpecFolderUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
