@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin

import com.pulumi.azurenative.purview.AccountArgs.builder
import com.pulumi.azurenative.purview.kotlin.enums.ManagedEventHubState
import com.pulumi.azurenative.purview.kotlin.enums.ManagedResourcesPublicNetworkAccess
import com.pulumi.azurenative.purview.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.purview.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.purview.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Account resource
 * Azure REST API version: 2021-12-01. Prior API version in Azure Native 1.x: 2020-12-01-preview.
 * Other available API versions: 2020-12-01-preview, 2021-07-01, 2023-05-01-preview.
 * ## Example Usage
 * ### Accounts_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.Purview.Account("account", new()
 *     {
 *         AccountName = "account1",
 *         Location = "West US 2",
 *         ManagedResourceGroupName = "custom-rgname",
 *         ManagedResourcesPublicNetworkAccess = "Enabled",
 *         ResourceGroupName = "SampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/purview/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := purview.NewAccount(ctx, "account", &purview.AccountArgs{
 * 			AccountName:                         pulumi.String("account1"),
 * 			Location:                            pulumi.String("West US 2"),
 * 			ManagedResourceGroupName:            pulumi.String("custom-rgname"),
 * 			ManagedResourcesPublicNetworkAccess: pulumi.String("Enabled"),
 * 			ResourceGroupName:                   pulumi.String("SampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.purview.Account;
 * import com.pulumi.azurenative.purview.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("account1")
 *             .location("West US 2")
 *             .managedResourceGroupName("custom-rgname")
 *             .managedResourcesPublicNetworkAccess("Enabled")
 *             .resourceGroupName("SampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:purview:Account account1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Purview/accounts/{accountName}
 * ```
 * @property accountName The name of the account.
 * @property identity Identity Info on the tracked resource
 * @property location Gets or sets the location.
 * @property managedEventHubState  Gets or sets the state of managed eventhub. If enabled managed eventhub will be created, if disabled the managed eventhub will be removed.
 * @property managedResourceGroupName Gets or sets the managed resource group name
 * @property managedResourcesPublicNetworkAccess Gets or sets the public network access for managed resources.
 * @property publicNetworkAccess Gets or sets the public network access.
 * @property resourceGroupName The resource group name.
 * @property tags Tags on the azure resource.
 */
public data class AccountArgs(
    public val accountName: Output<String>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val managedEventHubState: Output<Either<String, ManagedEventHubState>>? = null,
    public val managedResourceGroupName: Output<String>? = null,
    public val managedResourcesPublicNetworkAccess:
    Output<Either<String, ManagedResourcesPublicNetworkAccess>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.purview.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.purview.AccountArgs =
        com.pulumi.azurenative.purview.AccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedEventHubState(
                managedEventHubState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .managedResourceGroupName(managedResourceGroupName?.applyValue({ args0 -> args0 }))
            .managedResourcesPublicNetworkAccess(
                managedResourcesPublicNetworkAccess?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var managedEventHubState: Output<Either<String, ManagedEventHubState>>? = null

    private var managedResourceGroupName: Output<String>? = null

    private var managedResourcesPublicNetworkAccess:
        Output<Either<String, ManagedResourcesPublicNetworkAccess>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the account.
     */
    @JvmName("uhyainshkehjoqti")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Identity Info on the tracked resource
     */
    @JvmName("jsqiqxsoagumoetp")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("gbrgjqjpgbhhouoa")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value  Gets or sets the state of managed eventhub. If enabled managed eventhub will be created, if disabled the managed eventhub will be removed.
     */
    @JvmName("ekftqwrylblrnkaa")
    public suspend fun managedEventHubState(`value`: Output<Either<String, ManagedEventHubState>>) {
        this.managedEventHubState = value
    }

    /**
     * @param value Gets or sets the managed resource group name
     */
    @JvmName("kqjqnjuxekfaidqq")
    public suspend fun managedResourceGroupName(`value`: Output<String>) {
        this.managedResourceGroupName = value
    }

    /**
     * @param value Gets or sets the public network access for managed resources.
     */
    @JvmName("fncevillghlupfwg")
    public suspend
    fun managedResourcesPublicNetworkAccess(`value`: Output<Either<String, ManagedResourcesPublicNetworkAccess>>) {
        this.managedResourcesPublicNetworkAccess = value
    }

    /**
     * @param value Gets or sets the public network access.
     */
    @JvmName("xsymbbgbljkyamnn")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("okfcamaptftufsvc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags on the azure resource.
     */
    @JvmName("phskeruthloyebuu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the account.
     */
    @JvmName("lwbloaigsrjyqqin")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Identity Info on the tracked resource
     */
    @JvmName("imltpjhduprshiew")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity Info on the tracked resource
     */
    @JvmName("sqsacpnxmktnxnkx")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("kjfwkjckoangfclm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value  Gets or sets the state of managed eventhub. If enabled managed eventhub will be created, if disabled the managed eventhub will be removed.
     */
    @JvmName("fkcqmetvctigiure")
    public suspend fun managedEventHubState(`value`: Either<String, ManagedEventHubState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedEventHubState = mapped
    }

    /**
     * @param value  Gets or sets the state of managed eventhub. If enabled managed eventhub will be created, if disabled the managed eventhub will be removed.
     */
    @JvmName("llentllnsjiicxtr")
    public fun managedEventHubState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedEventHubState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedEventHubState = mapped
    }

    /**
     * @param value  Gets or sets the state of managed eventhub. If enabled managed eventhub will be created, if disabled the managed eventhub will be removed.
     */
    @JvmName("nelyivhjggcgbaam")
    public fun managedEventHubState(`value`: ManagedEventHubState) {
        val toBeMapped = Either.ofRight<String, ManagedEventHubState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedEventHubState = mapped
    }

    /**
     * @param value Gets or sets the managed resource group name
     */
    @JvmName("ofvvnfekuxsyvaja")
    public suspend fun managedResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the public network access for managed resources.
     */
    @JvmName("ataqjbwkcvvaiofd")
    public suspend
    fun managedResourcesPublicNetworkAccess(`value`: Either<String, ManagedResourcesPublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourcesPublicNetworkAccess = mapped
    }

    /**
     * @param value Gets or sets the public network access for managed resources.
     */
    @JvmName("phobovbrmntghhfr")
    public fun managedResourcesPublicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedResourcesPublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedResourcesPublicNetworkAccess = mapped
    }

    /**
     * @param value Gets or sets the public network access for managed resources.
     */
    @JvmName("eshwlrjyugcktwxo")
    public fun managedResourcesPublicNetworkAccess(`value`: ManagedResourcesPublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, ManagedResourcesPublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedResourcesPublicNetworkAccess = mapped
    }

    /**
     * @param value Gets or sets the public network access.
     */
    @JvmName("dxjsmwdgqywunhcf")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Gets or sets the public network access.
     */
    @JvmName("kuqcqkphxnbcuaoh")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Gets or sets the public network access.
     */
    @JvmName("qdrysnhupdgntwpw")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("hlrjidacbplpwrpt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags on the azure resource.
     */
    @JvmName("tepgqftdvmubhjqa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags on the azure resource.
     */
    @JvmName("qiyhirmbecmejkne")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountName = accountName,
        identity = identity,
        location = location,
        managedEventHubState = managedEventHubState,
        managedResourceGroupName = managedResourceGroupName,
        managedResourcesPublicNetworkAccess = managedResourcesPublicNetworkAccess,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
