@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin

import com.pulumi.azurenative.purview.kotlin.outputs.CredentialsResponse
import com.pulumi.azurenative.purview.kotlin.outputs.ProxyResourceResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.purview.kotlin.outputs.CredentialsResponse.Companion.toKotlin as credentialsResponseToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.ProxyResourceResponseSystemData.Companion.toKotlin as proxyResourceResponseSystemDataToKotlin

/**
 * Builder for [KafkaConfiguration].
 */
@PulumiTagMarker
public class KafkaConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KafkaConfigurationArgs = KafkaConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KafkaConfigurationArgsBuilder.() -> Unit) {
        val builder = KafkaConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KafkaConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.purview.KafkaConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return KafkaConfiguration(builtJavaResource)
    }
}

/**
 * The configuration of the event streaming service resource attached to the Purview account for kafka notifications.
 * Azure REST API version: 2021-12-01.
 * Other available API versions: 2023-05-01-preview.
 * ## Example Usage
 * ### KafkaConfigurations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kafkaConfiguration = new AzureNative.Purview.KafkaConfiguration("kafkaConfiguration", new()
 *     {
 *         AccountName = "account1",
 *         ConsumerGroup = "consumerGroup",
 *         Credentials = new AzureNative.Purview.Inputs.CredentialsArgs
 *         {
 *             IdentityId = "/subscriptions/47e8596d-ee73-4eb2-b6b4-cc13c2b87ssd/resourceGroups/testRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testId",
 *             Type = "UserAssigned",
 *         },
 *         EventHubPartitionId = "partitionId",
 *         EventHubResourceId = "/subscriptions/225be6fe-ec1c-4d51-a368-f69348d2e6c5/resourceGroups/testRG/providers/Microsoft.EventHub/namespaces/eventHubNameSpaceName",
 *         EventHubType = "Notification",
 *         EventStreamingState = "Enabled",
 *         EventStreamingType = "Azure",
 *         KafkaConfigurationName = "kafkaConfigName",
 *         ResourceGroupName = "rgpurview",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/purview/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := purview.NewKafkaConfiguration(ctx, "kafkaConfiguration", &purview.KafkaConfigurationArgs{
 * 			AccountName:   pulumi.String("account1"),
 * 			ConsumerGroup: pulumi.String("consumerGroup"),
 * 			Credentials: &purview.CredentialsArgs{
 * 				IdentityId: pulumi.String("/subscriptions/47e8596d-ee73-4eb2-b6b4-cc13c2b87ssd/resourceGroups/testRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testId"),
 * 				Type:       pulumi.String("UserAssigned"),
 * 			},
 * 			EventHubPartitionId:    pulumi.String("partitionId"),
 * 			EventHubResourceId:     pulumi.String("/subscriptions/225be6fe-ec1c-4d51-a368-f69348d2e6c5/resourceGroups/testRG/providers/Microsoft.EventHub/namespaces/eventHubNameSpaceName"),
 * 			EventHubType:           pulumi.String("Notification"),
 * 			EventStreamingState:    pulumi.String("Enabled"),
 * 			EventStreamingType:     pulumi.String("Azure"),
 * 			KafkaConfigurationName: pulumi.String("kafkaConfigName"),
 * 			ResourceGroupName:      pulumi.String("rgpurview"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.purview.KafkaConfiguration;
 * import com.pulumi.azurenative.purview.KafkaConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kafkaConfiguration = new KafkaConfiguration("kafkaConfiguration", KafkaConfigurationArgs.builder()
 *             .accountName("account1")
 *             .consumerGroup("consumerGroup")
 *             .credentials(Map.ofEntries(
 *                 Map.entry("identityId", "/subscriptions/47e8596d-ee73-4eb2-b6b4-cc13c2b87ssd/resourceGroups/testRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testId"),
 *                 Map.entry("type", "UserAssigned")
 *             ))
 *             .eventHubPartitionId("partitionId")
 *             .eventHubResourceId("/subscriptions/225be6fe-ec1c-4d51-a368-f69348d2e6c5/resourceGroups/testRG/providers/Microsoft.EventHub/namespaces/eventHubNameSpaceName")
 *             .eventHubType("Notification")
 *             .eventStreamingState("Enabled")
 *             .eventStreamingType("Azure")
 *             .kafkaConfigurationName("kafkaConfigName")
 *             .resourceGroupName("rgpurview")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:purview:KafkaConfiguration kafkaConfigName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Purview/accounts/{accountName}/kafkaConfigurations/{kafkaConfigurationName}
 * ```
 */
public class KafkaConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.purview.KafkaConfiguration,
) : KotlinCustomResource(javaResource, KafkaConfigurationMapper) {
    /**
     * Consumer group for hook event hub.
     */
    public val consumerGroup: Output<String>?
        get() = javaResource.consumerGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Credentials to access event hub.
     */
    public val credentials: Output<CredentialsResponse>?
        get() = javaResource.credentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    credentialsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Optional partition Id for notification event hub. If not set, all partitions will be leveraged.
     */
    public val eventHubPartitionId: Output<String>?
        get() = javaResource.eventHubPartitionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val eventHubResourceId: Output<String>?
        get() = javaResource.eventHubResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The event hub type.
     */
    public val eventHubType: Output<String>?
        get() = javaResource.eventHubType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the event streaming service
     */
    public val eventStreamingState: Output<String>?
        get() = javaResource.eventStreamingState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The event streaming service type
     */
    public val eventStreamingType: Output<String>?
        get() = javaResource.eventStreamingType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<ProxyResourceResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                proxyResourceResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Gets or sets the type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object KafkaConfigurationMapper : ResourceMapper<KafkaConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.purview.KafkaConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): KafkaConfiguration = KafkaConfiguration(
        javaResource as
            com.pulumi.azurenative.purview.KafkaConfiguration,
    )
}

/**
 * @see [KafkaConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KafkaConfiguration].
 */
public suspend fun kafkaConfiguration(
    name: String,
    block: suspend KafkaConfigurationResourceBuilder.() -> Unit,
): KafkaConfiguration {
    val builder = KafkaConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KafkaConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kafkaConfiguration(name: String): KafkaConfiguration {
    val builder = KafkaConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
