@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.inputs

import com.pulumi.azurenative.purview.inputs.ListFeatureSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property features Set of features
 * @property locations Location of feature.
 */
public data class ListFeatureSubscriptionPlainArgs(
    public val features: List<String>? = null,
    public val locations: String,
) : ConvertibleToJava<com.pulumi.azurenative.purview.inputs.ListFeatureSubscriptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.purview.inputs.ListFeatureSubscriptionPlainArgs =
        com.pulumi.azurenative.purview.inputs.ListFeatureSubscriptionPlainArgs.builder()
            .features(features?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .locations(locations.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListFeatureSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class ListFeatureSubscriptionPlainArgsBuilder internal constructor() {
    private var features: List<String>? = null

    private var locations: String? = null

    /**
     * @param value Set of features
     */
    @JvmName("leobpygntdpwhtmk")
    public suspend fun features(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.features = mapped
    }

    /**
     * @param values Set of features
     */
    @JvmName("psaovvgvmqxonxkc")
    public suspend fun features(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.features = mapped
    }

    /**
     * @param value Location of feature.
     */
    @JvmName("namtgvukcjnlywyj")
    public suspend fun locations(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.locations = mapped
    }

    internal fun build(): ListFeatureSubscriptionPlainArgs = ListFeatureSubscriptionPlainArgs(
        features = features,
        locations = locations ?: throw PulumiNullFieldException("locations"),
    )
}
