@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets the resource identifiers of the managed resources.
 * @property eventHubNamespace Gets the managed event hub namespace resource identifier.
 * @property resourceGroup Gets the managed resource group resource identifier. This resource group will host resource dependencies for the account.
 * @property storageAccount Gets the managed storage account resource identifier.
 */
public data class AccountPropertiesResponseManagedResources(
    public val eventHubNamespace: String,
    public val resourceGroup: String,
    public val storageAccount: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.AccountPropertiesResponseManagedResources):
            AccountPropertiesResponseManagedResources = AccountPropertiesResponseManagedResources(
            eventHubNamespace = javaType.eventHubNamespace(),
            resourceGroup = javaType.resourceGroup(),
            storageAccount = javaType.storageAccount(),
        )
    }
}
