@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * External Cloud Service connectors
 * @property awsExternalId AWS external identifier.
 * Configured in AWS to allow use of the role arn used for scanning
 */
public data class CloudConnectorsResponse(
    public val awsExternalId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.CloudConnectorsResponse):
            CloudConnectorsResponse = CloudConnectorsResponse(
            awsExternalId = javaType.awsExternalId(),
        )
    }
}
