@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quantum.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Result of list Api keys and connection strings.
 * @property apiKeyEnabled Indicator of enablement of the Quantum workspace Api keys.
 * @property primaryConnectionString The connection string of the primary api key.
 * @property primaryKey The quantum workspace primary api key.
 * @property secondaryConnectionString The connection string of the secondary api key.
 * @property secondaryKey The quantum workspace secondary api key.
 */
public data class ListWorkspaceKeysResult(
    public val apiKeyEnabled: Boolean? = null,
    public val primaryConnectionString: String,
    public val primaryKey: ApiKeyResponse? = null,
    public val secondaryConnectionString: String,
    public val secondaryKey: ApiKeyResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.quantum.outputs.ListWorkspaceKeysResult):
            ListWorkspaceKeysResult = ListWorkspaceKeysResult(
            apiKeyEnabled = javaType.apiKeyEnabled().map({ args0 -> args0 }).orElse(null),
            primaryConnectionString = javaType.primaryConnectionString(),
            primaryKey = javaType.primaryKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.quantum.kotlin.outputs.ApiKeyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            secondaryConnectionString = javaType.secondaryConnectionString(),
            secondaryKey = javaType.secondaryKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.quantum.kotlin.outputs.ApiKeyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
