@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin

import com.pulumi.azurenative.quota.QuotaFunctions.getGroupQuotaPlain
import com.pulumi.azurenative.quota.QuotaFunctions.getGroupQuotaSubscriptionPlain
import com.pulumi.azurenative.quota.kotlin.inputs.GetGroupQuotaPlainArgs
import com.pulumi.azurenative.quota.kotlin.inputs.GetGroupQuotaPlainArgsBuilder
import com.pulumi.azurenative.quota.kotlin.inputs.GetGroupQuotaSubscriptionPlainArgs
import com.pulumi.azurenative.quota.kotlin.inputs.GetGroupQuotaSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.quota.kotlin.outputs.GetGroupQuotaResult
import com.pulumi.azurenative.quota.kotlin.outputs.GetGroupQuotaSubscriptionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.quota.kotlin.outputs.GetGroupQuotaResult.Companion.toKotlin as getGroupQuotaResultToKotlin
import com.pulumi.azurenative.quota.kotlin.outputs.GetGroupQuotaSubscriptionResult.Companion.toKotlin as getGroupQuotaSubscriptionResultToKotlin

public object QuotaFunctions {
    /**
     * Gets the GroupQuotas for the name passed. It will return the GroupQuotas properties only. The details on groupQuota can be access from the groupQuota APIs.
     * Azure REST API version: 2023-06-01-preview.
     * @param argument null
     * @return Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified.
     */
    public suspend fun getGroupQuota(argument: GetGroupQuotaPlainArgs): GetGroupQuotaResult =
        getGroupQuotaResultToKotlin(getGroupQuotaPlain(argument.toJava()).await())

    /**
     * @see [getGroupQuota].
     * @param groupQuotaName The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
     * @param mgId Management Group Id.
     * @return Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified.
     */
    public suspend fun getGroupQuota(groupQuotaName: String, mgId: String): GetGroupQuotaResult {
        val argument = GetGroupQuotaPlainArgs(
            groupQuotaName = groupQuotaName,
            mgId = mgId,
        )
        return getGroupQuotaResultToKotlin(getGroupQuotaPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroupQuota].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;quota&#46;kotlin&#46;inputs&#46;GetGroupQuotaPlainArgs].
     * @return Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified.
     */
    public suspend fun getGroupQuota(argument: suspend GetGroupQuotaPlainArgsBuilder.() -> Unit):
        GetGroupQuotaResult {
        val builder = GetGroupQuotaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupQuotaResultToKotlin(getGroupQuotaPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the subscriptionId along with its provisioning state for being associated with the GroupQuotasEntity.
     * Azure REST API version: 2023-06-01-preview.
     * @param argument null
     * @return This represents a Azure subscriptionId that is associated with a GroupQuotaSEntity.
     */
    public suspend fun getGroupQuotaSubscription(argument: GetGroupQuotaSubscriptionPlainArgs):
        GetGroupQuotaSubscriptionResult =
        getGroupQuotaSubscriptionResultToKotlin(getGroupQuotaSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getGroupQuotaSubscription].
     * @param groupQuotaName The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
     * @param mgId Management Group Id.
     * @return This represents a Azure subscriptionId that is associated with a GroupQuotaSEntity.
     */
    public suspend fun getGroupQuotaSubscription(groupQuotaName: String, mgId: String):
        GetGroupQuotaSubscriptionResult {
        val argument = GetGroupQuotaSubscriptionPlainArgs(
            groupQuotaName = groupQuotaName,
            mgId = mgId,
        )
        return getGroupQuotaSubscriptionResultToKotlin(getGroupQuotaSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroupQuotaSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;quota&#46;kotlin&#46;inputs&#46;GetGroupQuotaSubscriptionPlainArgs].
     * @return This represents a Azure subscriptionId that is associated with a GroupQuotaSEntity.
     */
    public suspend
    fun getGroupQuotaSubscription(argument: suspend GetGroupQuotaSubscriptionPlainArgsBuilder.() -> Unit):
        GetGroupQuotaSubscriptionResult {
        val builder = GetGroupQuotaSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupQuotaSubscriptionResultToKotlin(getGroupQuotaSubscriptionPlain(builtArgument.toJava()).await())
    }
}
