@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * GroupingId type. It is a required property. More types of groupIds can be supported in future. MGID is already in the URI, so it's not needed.'
 */
public enum class GroupingIdType(
    public val javaValue: com.pulumi.azurenative.quota.enums.GroupingIdType,
) : ConvertibleToJava<com.pulumi.azurenative.quota.enums.GroupingIdType> {
    ServiceTreeId(com.pulumi.azurenative.quota.enums.GroupingIdType.ServiceTreeId),
    BillingId(com.pulumi.azurenative.quota.enums.GroupingIdType.BillingId),
    ;

    override fun toJava(): com.pulumi.azurenative.quota.enums.GroupingIdType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.quota.enums.GroupingIdType): GroupingIdType =
            GroupingIdType.values().first { it.javaValue == javaType }
    }
}
