@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin.inputs

import com.pulumi.azurenative.quota.inputs.AdditionalAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Additional attribute to allow subscriptions to be part of the GroupQuota.
 * @property environment
 * @property groupId The grouping Id for the group quota. It can be management Group Id or ServiceTreeId if applicable.
 */
public data class AdditionalAttributesArgs(
    public val environment: Output<Any>? = null,
    public val groupId: Output<GroupingIdArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.quota.inputs.AdditionalAttributesArgs> {
    override fun toJava(): com.pulumi.azurenative.quota.inputs.AdditionalAttributesArgs =
        com.pulumi.azurenative.quota.inputs.AdditionalAttributesArgs.builder()
            .environment(environment?.applyValue({ args0 -> args0 }))
            .groupId(groupId.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AdditionalAttributesArgs].
 */
@PulumiTagMarker
public class AdditionalAttributesArgsBuilder internal constructor() {
    private var environment: Output<Any>? = null

    private var groupId: Output<GroupingIdArgs>? = null

    /**
     * @param value
     */
    @JvmName("mxpkiqpnxfmdegyk")
    public suspend fun environment(`value`: Output<Any>) {
        this.environment = value
    }

    /**
     * @param value The grouping Id for the group quota. It can be management Group Id or ServiceTreeId if applicable.
     */
    @JvmName("htithukcdxcocdge")
    public suspend fun groupId(`value`: Output<GroupingIdArgs>) {
        this.groupId = value
    }

    /**
     * @param value
     */
    @JvmName("iheqrtblhkfccihn")
    public suspend fun environment(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param value The grouping Id for the group quota. It can be management Group Id or ServiceTreeId if applicable.
     */
    @JvmName("ttuvliqtecyagjll")
    public suspend fun groupId(`value`: GroupingIdArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param argument The grouping Id for the group quota. It can be management Group Id or ServiceTreeId if applicable.
     */
    @JvmName("fjkbjwfyujqcedvj")
    public suspend fun groupId(argument: suspend GroupingIdArgsBuilder.() -> Unit) {
        val toBeMapped = GroupingIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.groupId = mapped
    }

    internal fun build(): AdditionalAttributesArgs = AdditionalAttributesArgs(
        environment = environment,
        groupId = groupId ?: throw PulumiNullFieldException("groupId"),
    )
}
