@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin

import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.ModelingResourceResponseProperties
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.ModelingResourceResponseProperties.Companion.toKotlin as modelingResourceResponsePropertiesToKotlin
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Modeling].
 */
@PulumiTagMarker
public class ModelingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModelingArgs = ModelingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModelingArgsBuilder.() -> Unit) {
        val builder = ModelingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Modeling {
        val builtJavaResource =
            com.pulumi.azurenative.recommendationsservice.Modeling(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Modeling(builtJavaResource)
    }
}

/**
 * Modeling resource details.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * Other available API versions: 2022-03-01-preview.
 * ## Example Usage
 * ### Create or update Modeling resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var modeling = new AzureNative.RecommendationsService.Modeling("modeling", new()
 *     {
 *         AccountName = "sampleAccount",
 *         Location = "West US",
 *         ModelingName = "c1",
 *         Properties = new AzureNative.RecommendationsService.Inputs.ModelingResourcePropertiesArgs
 *         {
 *             Features = "Standard",
 *             Frequency = "High",
 *             InputData = new AzureNative.RecommendationsService.Inputs.ModelingInputDataArgs
 *             {
 *                 ConnectionString = "https://storageAccount.blob.core.windows.net/container/root",
 *             },
 *             Size = "Medium",
 *         },
 *         ResourceGroupName = "rg",
 *         Tags =
 *         {
 *             { "Environment", "Prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recommendationsservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recommendationsservice.NewModeling(ctx, "modeling", &recommendationsservice.ModelingArgs{
 * 			AccountName:  pulumi.String("sampleAccount"),
 * 			Location:     pulumi.String("West US"),
 * 			ModelingName: pulumi.String("c1"),
 * 			Properties: recommendationsservice.ModelingResourceResponseProperties{
 * 				Features:  pulumi.String("Standard"),
 * 				Frequency: pulumi.String("High"),
 * 				InputData: &recommendationsservice.ModelingInputDataArgs{
 * 					ConnectionString: pulumi.String("https://storageAccount.blob.core.windows.net/container/root"),
 * 				},
 * 				Size: pulumi.String("Medium"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recommendationsservice.Modeling;
 * import com.pulumi.azurenative.recommendationsservice.ModelingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var modeling = new Modeling("modeling", ModelingArgs.builder()
 *             .accountName("sampleAccount")
 *             .location("West US")
 *             .modelingName("c1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("features", "Standard"),
 *                 Map.entry("frequency", "High"),
 *                 Map.entry("inputData", Map.of("connectionString", "https://storageAccount.blob.core.windows.net/container/root")),
 *                 Map.entry("size", "Medium")
 *             ))
 *             .resourceGroupName("rg")
 *             .tags(Map.of("Environment", "Prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recommendationsservice:Modeling c1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecommendationsService/accounts/{accountName}/modeling/{modelingName}
 * ```
 */
public class Modeling internal constructor(
    override val javaResource: com.pulumi.azurenative.recommendationsservice.Modeling,
) : KotlinCustomResource(javaResource, ModelingMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Modeling resource properties.
     */
    public val properties: Output<ModelingResourceResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                modelingResourceResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ModelingMapper : ResourceMapper<Modeling> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recommendationsservice.Modeling::class == javaResource::class

    override fun map(javaResource: Resource): Modeling = Modeling(
        javaResource as
            com.pulumi.azurenative.recommendationsservice.Modeling,
    )
}

/**
 * @see [Modeling].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Modeling].
 */
public suspend fun modeling(name: String, block: suspend ModelingResourceBuilder.() -> Unit):
    Modeling {
    val builder = ModelingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Modeling].
 * @param name The _unique_ name of the resulting resource.
 */
public fun modeling(name: String): Modeling {
    val builder = ModelingResourceBuilder()
    builder.name(name)
    return builder.build()
}
