@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin

import com.pulumi.azurenative.recommendationsservice.ModelingArgs.builder
import com.pulumi.azurenative.recommendationsservice.kotlin.inputs.ModelingResourcePropertiesArgs
import com.pulumi.azurenative.recommendationsservice.kotlin.inputs.ModelingResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Modeling resource details.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * Other available API versions: 2022-03-01-preview.
 * ## Example Usage
 * ### Create or update Modeling resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var modeling = new AzureNative.RecommendationsService.Modeling("modeling", new()
 *     {
 *         AccountName = "sampleAccount",
 *         Location = "West US",
 *         ModelingName = "c1",
 *         Properties = new AzureNative.RecommendationsService.Inputs.ModelingResourcePropertiesArgs
 *         {
 *             Features = "Standard",
 *             Frequency = "High",
 *             InputData = new AzureNative.RecommendationsService.Inputs.ModelingInputDataArgs
 *             {
 *                 ConnectionString = "https://storageAccount.blob.core.windows.net/container/root",
 *             },
 *             Size = "Medium",
 *         },
 *         ResourceGroupName = "rg",
 *         Tags =
 *         {
 *             { "Environment", "Prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recommendationsservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recommendationsservice.NewModeling(ctx, "modeling", &recommendationsservice.ModelingArgs{
 * 			AccountName:  pulumi.String("sampleAccount"),
 * 			Location:     pulumi.String("West US"),
 * 			ModelingName: pulumi.String("c1"),
 * 			Properties: recommendationsservice.ModelingResourceResponseProperties{
 * 				Features:  pulumi.String("Standard"),
 * 				Frequency: pulumi.String("High"),
 * 				InputData: &recommendationsservice.ModelingInputDataArgs{
 * 					ConnectionString: pulumi.String("https://storageAccount.blob.core.windows.net/container/root"),
 * 				},
 * 				Size: pulumi.String("Medium"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recommendationsservice.Modeling;
 * import com.pulumi.azurenative.recommendationsservice.ModelingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var modeling = new Modeling("modeling", ModelingArgs.builder()
 *             .accountName("sampleAccount")
 *             .location("West US")
 *             .modelingName("c1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("features", "Standard"),
 *                 Map.entry("frequency", "High"),
 *                 Map.entry("inputData", Map.of("connectionString", "https://storageAccount.blob.core.windows.net/container/root")),
 *                 Map.entry("size", "Medium")
 *             ))
 *             .resourceGroupName("rg")
 *             .tags(Map.of("Environment", "Prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recommendationsservice:Modeling c1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecommendationsService/accounts/{accountName}/modeling/{modelingName}
 * ```
 * @property accountName The name of the RecommendationsService Account resource.
 * @property location The geo-location where the resource lives
 * @property modelingName The name of the Modeling resource.
 * @property properties Modeling resource properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ModelingArgs(
    public val accountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val modelingName: Output<String>? = null,
    public val properties: Output<ModelingResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recommendationsservice.ModelingArgs> {
    override fun toJava(): com.pulumi.azurenative.recommendationsservice.ModelingArgs =
        com.pulumi.azurenative.recommendationsservice.ModelingArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .modelingName(modelingName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ModelingArgs].
 */
@PulumiTagMarker
public class ModelingArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var location: Output<String>? = null

    private var modelingName: Output<String>? = null

    private var properties: Output<ModelingResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the RecommendationsService Account resource.
     */
    @JvmName("jscxkjgbxviuofeq")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mcoruwpcgboeafgk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Modeling resource.
     */
    @JvmName("dipbskiehqbaeyjh")
    public suspend fun modelingName(`value`: Output<String>) {
        this.modelingName = value
    }

    /**
     * @param value Modeling resource properties.
     */
    @JvmName("ibgrnrdfjgnvtlhp")
    public suspend fun properties(`value`: Output<ModelingResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nrspnyyhxsnklwdt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ccjfwpkauevrkylk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the RecommendationsService Account resource.
     */
    @JvmName("wdyvhfuehrlbqete")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tdpwqwrldegowppl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Modeling resource.
     */
    @JvmName("xdcvyiivxknfsayv")
    public suspend fun modelingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelingName = mapped
    }

    /**
     * @param value Modeling resource properties.
     */
    @JvmName("yecugfytgffbmljf")
    public suspend fun properties(`value`: ModelingResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Modeling resource properties.
     */
    @JvmName("rerdxssapshlqhab")
    public suspend
    fun properties(argument: suspend ModelingResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ModelingResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ipoedahmnjurlryu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kpncpifpwstucsuq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("uxemfvyfqbioyptv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ModelingArgs = ModelingArgs(
        accountName = accountName,
        location = location,
        modelingName = modelingName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
