@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin

import com.pulumi.azurenative.recommendationsservice.ServiceEndpointArgs.builder
import com.pulumi.azurenative.recommendationsservice.kotlin.inputs.ServiceEndpointResourcePropertiesArgs
import com.pulumi.azurenative.recommendationsservice.kotlin.inputs.ServiceEndpointResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ServiceEndpoint resource details.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * Other available API versions: 2022-03-01-preview.
 * ## Example Usage
 * ### Create or update ServiceEndpoint resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceEndpoint = new AzureNative.RecommendationsService.ServiceEndpoint("serviceEndpoint", new()
 *     {
 *         AccountName = "sampleAccount",
 *         Location = "West US",
 *         Properties = new AzureNative.RecommendationsService.Inputs.ServiceEndpointResourcePropertiesArgs
 *         {
 *             PreAllocatedCapacity = 100,
 *         },
 *         ResourceGroupName = "rg",
 *         ServiceEndpointName = "s1",
 *         Tags =
 *         {
 *             { "Environment", "Prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recommendationsservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recommendationsservice.NewServiceEndpoint(ctx, "serviceEndpoint", &recommendationsservice.ServiceEndpointArgs{
 * 			AccountName: pulumi.String("sampleAccount"),
 * 			Location:    pulumi.String("West US"),
 * 			Properties: &recommendationsservice.ServiceEndpointResourcePropertiesArgs{
 * 				PreAllocatedCapacity: pulumi.Int(100),
 * 			},
 * 			ResourceGroupName:   pulumi.String("rg"),
 * 			ServiceEndpointName: pulumi.String("s1"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recommendationsservice.ServiceEndpoint;
 * import com.pulumi.azurenative.recommendationsservice.ServiceEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceEndpoint = new ServiceEndpoint("serviceEndpoint", ServiceEndpointArgs.builder()
 *             .accountName("sampleAccount")
 *             .location("West US")
 *             .properties(Map.of("preAllocatedCapacity", 100))
 *             .resourceGroupName("rg")
 *             .serviceEndpointName("s1")
 *             .tags(Map.of("Environment", "Prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recommendationsservice:ServiceEndpoint s1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecommendationsService/accounts/{accountName}/serviceEndpoints/{serviceEndpointName}
 * ```
 * @property accountName The name of the RecommendationsService Account resource.
 * @property location The geo-location where the resource lives
 * @property properties ServiceEndpoint resource properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceEndpointName The name of the ServiceEndpoint resource.
 * @property tags Resource tags.
 */
public data class ServiceEndpointArgs(
    public val accountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ServiceEndpointResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceEndpointName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recommendationsservice.ServiceEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.recommendationsservice.ServiceEndpointArgs =
        com.pulumi.azurenative.recommendationsservice.ServiceEndpointArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceEndpointName(serviceEndpointName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceEndpointArgs].
 */
@PulumiTagMarker
public class ServiceEndpointArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<ServiceEndpointResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceEndpointName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the RecommendationsService Account resource.
     */
    @JvmName("jfepqjxrixibacec")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xasqgdalqfutsjiq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ServiceEndpoint resource properties.
     */
    @JvmName("tiixdwgenupltqyw")
    public suspend fun properties(`value`: Output<ServiceEndpointResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gfhslbwqoupxifyi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the ServiceEndpoint resource.
     */
    @JvmName("jypqmwgiyapghquh")
    public suspend fun serviceEndpointName(`value`: Output<String>) {
        this.serviceEndpointName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jfarhvpxwjmhtpws")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the RecommendationsService Account resource.
     */
    @JvmName("yubrewfewrmlxeyf")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("issriodyfwemjyxa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ServiceEndpoint resource properties.
     */
    @JvmName("fnpgqyaxnyqxwfnm")
    public suspend fun properties(`value`: ServiceEndpointResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument ServiceEndpoint resource properties.
     */
    @JvmName("bwyxxydsnhkkygya")
    public suspend
    fun properties(argument: suspend ServiceEndpointResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceEndpointResourcePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wigmjaeniyynqpjw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the ServiceEndpoint resource.
     */
    @JvmName("wjwbukfnafkkqckj")
    public suspend fun serviceEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpointName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("euthprsypfdkfknq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("psecdtpcrldxpywm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceEndpointArgs = ServiceEndpointArgs(
        accountName = accountName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceEndpointName = serviceEndpointName,
        tags = tags,
    )
}
