@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.inputs

import com.pulumi.azurenative.recommendationsservice.inputs.GetServiceEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the RecommendationsService Account resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceEndpointName The name of the ServiceEndpoint resource.
 */
public data class GetServiceEndpointPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val serviceEndpointName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.recommendationsservice.inputs.GetServiceEndpointPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.recommendationsservice.inputs.GetServiceEndpointPlainArgs =
        com.pulumi.azurenative.recommendationsservice.inputs.GetServiceEndpointPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceEndpointName(serviceEndpointName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetServiceEndpointPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var serviceEndpointName: String? = null

    /**
     * @param value The name of the RecommendationsService Account resource.
     */
    @JvmName("cwnycxhvlxlfcmld")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("blruibuxinsulisc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the ServiceEndpoint resource.
     */
    @JvmName("mgvniqwitlwuwjkw")
    public suspend fun serviceEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceEndpointName = mapped
    }

    internal fun build(): GetServiceEndpointPlainArgs = GetServiceEndpointPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceEndpointName = serviceEndpointName ?: throw PulumiNullFieldException("serviceEndpointName"),
    )
}
