@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.inputs

import com.pulumi.azurenative.recommendationsservice.inputs.ModelingInputDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration to raw CDM data to be used as Modeling resource input.
 * @property connectionString Connection string to raw input data.
 */
public data class ModelingInputDataArgs(
    public val connectionString: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recommendationsservice.inputs.ModelingInputDataArgs> {
    override fun toJava(): com.pulumi.azurenative.recommendationsservice.inputs.ModelingInputDataArgs =
        com.pulumi.azurenative.recommendationsservice.inputs.ModelingInputDataArgs.builder()
            .connectionString(connectionString?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModelingInputDataArgs].
 */
@PulumiTagMarker
public class ModelingInputDataArgsBuilder internal constructor() {
    private var connectionString: Output<String>? = null

    /**
     * @param value Connection string to raw input data.
     */
    @JvmName("xhtyfkydrxnnccyh")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value Connection string to raw input data.
     */
    @JvmName("uuqcniytdfposgsu")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    internal fun build(): ModelingInputDataArgs = ModelingInputDataArgs(
        connectionString = connectionString,
    )
}
