@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Account resource properties.
 * @property configuration Account configuration. This can only be set at RecommendationsService Account creation.
 * @property cors The list of CORS details.
 * @property endpointAuthentications The list of service endpoints authentication details.
 * @property provisioningState The resource provisioning state.
 * @property reportsConnectionString Connection string to write Accounts reports to.
 */
public data class AccountResourceResponseProperties(
    public val configuration: String? = null,
    public val cors: List<CorsRuleResponse>? = null,
    public val endpointAuthentications: List<EndpointAuthenticationResponse>? = null,
    public val provisioningState: String,
    public val reportsConnectionString: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recommendationsservice.outputs.AccountResourceResponseProperties):
            AccountResourceResponseProperties = AccountResourceResponseProperties(
            configuration = javaType.configuration().map({ args0 -> args0 }).orElse(null),
            cors = javaType.cors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recommendationsservice.kotlin.outputs.CorsRuleResponse.Companion.toKotlin(args0)
                })
            }),
            endpointAuthentications = javaType.endpointAuthentications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recommendationsservice.kotlin.outputs.EndpointAuthenticationResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            reportsConnectionString = javaType.reportsConnectionString().map({ args0 -> args0 }).orElse(null),
        )
    }
}
