@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration to raw CDM data to be used as Modeling resource input.
 * @property connectionString Connection string to raw input data.
 */
public data class ModelingInputDataResponse(
    public val connectionString: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recommendationsservice.outputs.ModelingInputDataResponse):
            ModelingInputDataResponse = ModelingInputDataResponse(
            connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
        )
    }
}
