@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Modeling resource properties.
 * @property features Modeling features controls the set of supported scenarios\models being computed. This can only be set at Modeling creation.
 * @property frequency Modeling frequency controls the modeling compute frequency.
 * @property inputData The configuration to raw CDM data to be used as Modeling resource input.
 * @property provisioningState The resource provisioning state.
 * @property size Modeling size controls the maximum supported input data size.
 */
public data class ModelingResourceResponseProperties(
    public val features: String? = null,
    public val frequency: String? = null,
    public val inputData: ModelingInputDataResponse? = null,
    public val provisioningState: String,
    public val size: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recommendationsservice.outputs.ModelingResourceResponseProperties):
            ModelingResourceResponseProperties = ModelingResourceResponseProperties(
            features = javaType.features().map({ args0 -> args0 }).orElse(null),
            frequency = javaType.frequency().map({ args0 -> args0 }).orElse(null),
            inputData = javaType.inputData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recommendationsservice.kotlin.outputs.ModelingInputDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
        )
    }
}
