@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.FabricPropertiesResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.FabricPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationFabric].
 */
@PulumiTagMarker
public class ReplicationFabricResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationFabricArgs = ReplicationFabricArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationFabricArgsBuilder.() -> Unit) {
        val builder = ReplicationFabricArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationFabric {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ReplicationFabric(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationFabric(builtJavaResource)
    }
}

/**
 * Fabric definition.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01.
 * ## Example Usage
 * ### Creates an Azure Site Recovery fabric.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationFabric = new AzureNative.RecoveryServices.ReplicationFabric("replicationFabric", new()
 *     {
 *         FabricName = "cloud1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.FabricCreationInputPropertiesArgs
 *         {
 *             CustomDetails =
 *             {
 *                 { "instanceType", "FabricSpecificCreationInput" },
 *             },
 *         },
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := recoveryservices.NewReplicationFabric(ctx, "replicationFabric", &recoveryservices.ReplicationFabricArgs{
 * FabricName: pulumi.String("cloud1"),
 * Properties: recoveryservices.FabricPropertiesResponse{
 * CustomDetails: interface{}{
 * InstanceType: pulumi.String("FabricSpecificCreationInput"),
 * },
 * },
 * ResourceGroupName: pulumi.String("resourceGroupPS1"),
 * ResourceName: pulumi.String("vault1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationFabric;
 * import com.pulumi.azurenative.recoveryservices.ReplicationFabricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationFabric = new ReplicationFabric("replicationFabric", ReplicationFabricArgs.builder()
 *             .fabricName("cloud1")
 *             .properties(Map.of("customDetails", Map.of("instanceType", "FabricSpecificCreationInput")))
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationFabric cloud1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}
 * ```
 */
public class ReplicationFabric internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ReplicationFabric,
) : KotlinCustomResource(javaResource, ReplicationFabricMapper) {
    /**
     * Resource Location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Fabric related data.
     */
    public val properties: Output<FabricPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationFabricMapper : ResourceMapper<ReplicationFabric> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ReplicationFabric::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationFabric = ReplicationFabric(
        javaResource as
            com.pulumi.azurenative.recoveryservices.ReplicationFabric,
    )
}

/**
 * @see [ReplicationFabric].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationFabric].
 */
public suspend fun replicationFabric(
    name: String,
    block: suspend ReplicationFabricResourceBuilder.() -> Unit,
): ReplicationFabric {
    val builder = ReplicationFabricResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationFabric].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationFabric(name: String): ReplicationFabric {
    val builder = ReplicationFabricResourceBuilder()
    builder.name(name)
    return builder.build()
}
