@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.MigrationItemPropertiesResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.MigrationItemPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationMigrationItem].
 */
@PulumiTagMarker
public class ReplicationMigrationItemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationMigrationItemArgs = ReplicationMigrationItemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationMigrationItemArgsBuilder.() -> Unit) {
        val builder = ReplicationMigrationItemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationMigrationItem {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ReplicationMigrationItem(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationMigrationItem(builtJavaResource)
    }
}

/**
 * Migration item.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01.
 * ## Example Usage
 * ### Enables migration.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationMigrationItem = new AzureNative.RecoveryServices.ReplicationMigrationItem("replicationMigrationItem", new()
 *     {
 *         FabricName = "vmwarefabric1",
 *         MigrationItemName = "virtualmachine1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.EnableMigrationInputPropertiesArgs
 *         {
 *             PolicyId = "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.RecoveryServices/vaults/migrationvault/replicationPolicies/vmwarepolicy1",
 *             ProviderSpecificDetails =
 *             {
 *                 { "dataMoverRunAsAccountId", "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/runasaccounts/dataMoverRunAsAccount1" },
 *                 { "disksToInclude", new[]
 *                 {
 *                     new AzureNative.RecoveryServices.Inputs.VMwareCbtDiskInputArgs
 *                     {
 *                         DiskId = "disk1",
 *                         IsOSDisk = "true",
 *                         LogStorageAccountId = "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.Storage/storageAccounts/logStorageAccount1",
 *                         LogStorageAccountSasSecretName = "logStorageSas",
 *                     },
 *                 } },
 *                 { "instanceType", "VMwareCbt" },
 *                 { "snapshotRunAsAccountId", "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/runasaccounts/snapshotRunAsAccount1" },
 *                 { "targetNetworkId", "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1" },
 *                 { "targetResourceGroupId", "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1" },
 *                 { "vmwareMachineId", "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/machines/virtualmachine1" },
 *             },
 *         },
 *         ProtectionContainerName = "vmwareContainer1",
 *         ResourceGroupName = "resourcegroup1",
 *         ResourceName = "migrationvault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := recoveryservices.NewReplicationMigrationItem(ctx, "replicationMigrationItem", &recoveryservices.ReplicationMigrationItemArgs{
 * FabricName: pulumi.String("vmwarefabric1"),
 * MigrationItemName: pulumi.String("virtualmachine1"),
 * Properties: recoveryservices.MigrationItemPropertiesResponse{
 * PolicyId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.RecoveryServices/vaults/migrationvault/replicationPolicies/vmwarepolicy1"),
 * ProviderSpecificDetails: interface{}{
 * DataMoverRunAsAccountId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/runasaccounts/dataMoverRunAsAccount1"),
 * DisksToInclude: recoveryservices.VMwareCbtDiskInputArray{
 * &recoveryservices.VMwareCbtDiskInputArgs{
 * DiskId: pulumi.String("disk1"),
 * IsOSDisk: pulumi.String("true"),
 * LogStorageAccountId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.Storage/storageAccounts/logStorageAccount1"),
 * LogStorageAccountSasSecretName: pulumi.String("logStorageSas"),
 * },
 * },
 * InstanceType: pulumi.String("VMwareCbt"),
 * SnapshotRunAsAccountId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/runasaccounts/snapshotRunAsAccount1"),
 * TargetNetworkId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1"),
 * TargetResourceGroupId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1"),
 * VmwareMachineId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/machines/virtualmachine1"),
 * },
 * },
 * ProtectionContainerName: pulumi.String("vmwareContainer1"),
 * ResourceGroupName: pulumi.String("resourcegroup1"),
 * ResourceName: pulumi.String("migrationvault"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationMigrationItem;
 * import com.pulumi.azurenative.recoveryservices.ReplicationMigrationItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationMigrationItem = new ReplicationMigrationItem("replicationMigrationItem", ReplicationMigrationItemArgs.builder()
 *             .fabricName("vmwarefabric1")
 *             .migrationItemName("virtualmachine1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("policyId", "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.RecoveryServices/vaults/migrationvault/replicationPolicies/vmwarepolicy1"),
 *                 Map.entry("providerSpecificDetails", Map.ofEntries(
 *                     Map.entry("dataMoverRunAsAccountId", "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/runasaccounts/dataMoverRunAsAccount1"),
 *                     Map.entry("disksToInclude", Map.ofEntries(
 *                         Map.entry("diskId", "disk1"),
 *                         Map.entry("isOSDisk", "true"),
 *                         Map.entry("logStorageAccountId", "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.Storage/storageAccounts/logStorageAccount1"),
 *                         Map.entry("logStorageAccountSasSecretName", "logStorageSas")
 *                     )),
 *                     Map.entry("instanceType", "VMwareCbt"),
 *                     Map.entry("snapshotRunAsAccountId", "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/runasaccounts/snapshotRunAsAccount1"),
 *                     Map.entry("targetNetworkId", "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1"),
 *                     Map.entry("targetResourceGroupId", "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1"),
 *                     Map.entry("vmwareMachineId", "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/machines/virtualmachine1")
 *                 ))
 *             ))
 *             .protectionContainerName("vmwareContainer1")
 *             .resourceGroupName("resourcegroup1")
 *             .resourceName("migrationvault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationMigrationItem virtualmachine1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems/{migrationItemName}
 * ```
 */
public class ReplicationMigrationItem internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ReplicationMigrationItem,
) : KotlinCustomResource(javaResource, ReplicationMigrationItemMapper) {
    /**
     * Resource Location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The migration item properties.
     */
    public val properties: Output<MigrationItemPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationMigrationItemMapper : ResourceMapper<ReplicationMigrationItem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ReplicationMigrationItem::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationMigrationItem =
        ReplicationMigrationItem(
            javaResource as
                com.pulumi.azurenative.recoveryservices.ReplicationMigrationItem,
        )
}

/**
 * @see [ReplicationMigrationItem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationMigrationItem].
 */
public suspend fun replicationMigrationItem(
    name: String,
    block: suspend ReplicationMigrationItemResourceBuilder.() -> Unit,
): ReplicationMigrationItem {
    val builder = ReplicationMigrationItemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationMigrationItem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationMigrationItem(name: String): ReplicationMigrationItem {
    val builder = ReplicationMigrationItemResourceBuilder()
    builder.name(name)
    return builder.build()
}
