@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Retention duration type: days/weeks/months/years
 * Used only if TieringMode is set to TierAfter
 */
public enum class RetentionDurationType(
    public val javaValue: com.pulumi.azurenative.recoveryservices.enums.RetentionDurationType,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.enums.RetentionDurationType> {
    Invalid(com.pulumi.azurenative.recoveryservices.enums.RetentionDurationType.Invalid),
    Days(com.pulumi.azurenative.recoveryservices.enums.RetentionDurationType.Days),
    Weeks(com.pulumi.azurenative.recoveryservices.enums.RetentionDurationType.Weeks),
    Months(com.pulumi.azurenative.recoveryservices.enums.RetentionDurationType.Months),
    Years(com.pulumi.azurenative.recoveryservices.enums.RetentionDurationType.Years),
    ;

    override fun toJava(): com.pulumi.azurenative.recoveryservices.enums.RetentionDurationType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.enums.RetentionDurationType):
            RetentionDurationType = RetentionDurationType.values().first { it.javaValue == javaType }
    }
}
