@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.A2AContainerMappingInputArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.AgentAutoUpdateStatus
import com.pulumi.azurenative.recoveryservices.kotlin.enums.AutomationAccountAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A2A container mapping input.
 * @property agentAutoUpdateStatus A value indicating whether the auto update is enabled.
 * @property automationAccountArmId The automation account arm id.
 * @property automationAccountAuthenticationType A value indicating the type authentication to use for automation Account.
 * @property instanceType The class type.
 * Expected value is 'A2A'.
 */
public data class A2AContainerMappingInputArgs(
    public val agentAutoUpdateStatus: Output<Either<String, AgentAutoUpdateStatus>>? = null,
    public val automationAccountArmId: Output<String>? = null,
    public val automationAccountAuthenticationType:
    Output<Either<String, AutomationAccountAuthenticationType>>? = null,
    public val instanceType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.A2AContainerMappingInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.A2AContainerMappingInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.A2AContainerMappingInputArgs.builder()
            .agentAutoUpdateStatus(
                agentAutoUpdateStatus?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .automationAccountArmId(automationAccountArmId?.applyValue({ args0 -> args0 }))
            .automationAccountAuthenticationType(
                automationAccountAuthenticationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [A2AContainerMappingInputArgs].
 */
@PulumiTagMarker
public class A2AContainerMappingInputArgsBuilder internal constructor() {
    private var agentAutoUpdateStatus: Output<Either<String, AgentAutoUpdateStatus>>? = null

    private var automationAccountArmId: Output<String>? = null

    private var automationAccountAuthenticationType:
        Output<Either<String, AutomationAccountAuthenticationType>>? = null

    private var instanceType: Output<String>? = null

    /**
     * @param value A value indicating whether the auto update is enabled.
     */
    @JvmName("potghbqjjogyqbti")
    public suspend fun agentAutoUpdateStatus(`value`: Output<Either<String, AgentAutoUpdateStatus>>) {
        this.agentAutoUpdateStatus = value
    }

    /**
     * @param value The automation account arm id.
     */
    @JvmName("glfrxukttccshpbv")
    public suspend fun automationAccountArmId(`value`: Output<String>) {
        this.automationAccountArmId = value
    }

    /**
     * @param value A value indicating the type authentication to use for automation Account.
     */
    @JvmName("vjsyrlblkhouwxwp")
    public suspend
    fun automationAccountAuthenticationType(`value`: Output<Either<String, AutomationAccountAuthenticationType>>) {
        this.automationAccountAuthenticationType = value
    }

    /**
     * @param value The class type.
     * Expected value is 'A2A'.
     */
    @JvmName("txtoextomlusjinu")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value A value indicating whether the auto update is enabled.
     */
    @JvmName("ruajwuslxofslwby")
    public suspend fun agentAutoUpdateStatus(`value`: Either<String, AgentAutoUpdateStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentAutoUpdateStatus = mapped
    }

    /**
     * @param value A value indicating whether the auto update is enabled.
     */
    @JvmName("sfafgaxfnbsajwuw")
    public fun agentAutoUpdateStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AgentAutoUpdateStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentAutoUpdateStatus = mapped
    }

    /**
     * @param value A value indicating whether the auto update is enabled.
     */
    @JvmName("pricdxbqhymxilyn")
    public fun agentAutoUpdateStatus(`value`: AgentAutoUpdateStatus) {
        val toBeMapped = Either.ofRight<String, AgentAutoUpdateStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentAutoUpdateStatus = mapped
    }

    /**
     * @param value The automation account arm id.
     */
    @JvmName("fyympclqylaypsct")
    public suspend fun automationAccountArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountArmId = mapped
    }

    /**
     * @param value A value indicating the type authentication to use for automation Account.
     */
    @JvmName("nsmhprmrnwddovra")
    public suspend
    fun automationAccountAuthenticationType(`value`: Either<String, AutomationAccountAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountAuthenticationType = mapped
    }

    /**
     * @param value A value indicating the type authentication to use for automation Account.
     */
    @JvmName("rlctbfkfkulaljay")
    public fun automationAccountAuthenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutomationAccountAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.automationAccountAuthenticationType = mapped
    }

    /**
     * @param value A value indicating the type authentication to use for automation Account.
     */
    @JvmName("ysjgvkutbdhhuptl")
    public fun automationAccountAuthenticationType(`value`: AutomationAccountAuthenticationType) {
        val toBeMapped = Either.ofRight<String, AutomationAccountAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.automationAccountAuthenticationType = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'A2A'.
     */
    @JvmName("kkthogsmhrhwcbyv")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    internal fun build(): A2AContainerMappingInputArgs = A2AContainerMappingInputArgs(
        agentAutoUpdateStatus = agentAutoUpdateStatus,
        automationAccountArmId = automationAccountArmId,
        automationAccountAuthenticationType = automationAccountAuthenticationType,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
    )
}
