@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.A2AVmDiskInputDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A2A disk input details.
 * @property diskUri The disk Uri.
 * @property primaryStagingAzureStorageAccountId The primary staging storage account Id.
 * @property recoveryAzureStorageAccountId The recovery VHD storage account Id.
 */
public data class A2AVmDiskInputDetailsArgs(
    public val diskUri: Output<String>,
    public val primaryStagingAzureStorageAccountId: Output<String>,
    public val recoveryAzureStorageAccountId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.A2AVmDiskInputDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.A2AVmDiskInputDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.A2AVmDiskInputDetailsArgs.builder()
            .diskUri(diskUri.applyValue({ args0 -> args0 }))
            .primaryStagingAzureStorageAccountId(
                primaryStagingAzureStorageAccountId.applyValue({ args0 ->
                    args0
                }),
            )
            .recoveryAzureStorageAccountId(recoveryAzureStorageAccountId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [A2AVmDiskInputDetailsArgs].
 */
@PulumiTagMarker
public class A2AVmDiskInputDetailsArgsBuilder internal constructor() {
    private var diskUri: Output<String>? = null

    private var primaryStagingAzureStorageAccountId: Output<String>? = null

    private var recoveryAzureStorageAccountId: Output<String>? = null

    /**
     * @param value The disk Uri.
     */
    @JvmName("oxrgiibitkqhnavh")
    public suspend fun diskUri(`value`: Output<String>) {
        this.diskUri = value
    }

    /**
     * @param value The primary staging storage account Id.
     */
    @JvmName("vrrasimoqxdxhipr")
    public suspend fun primaryStagingAzureStorageAccountId(`value`: Output<String>) {
        this.primaryStagingAzureStorageAccountId = value
    }

    /**
     * @param value The recovery VHD storage account Id.
     */
    @JvmName("ppcglxtmxdndsvtk")
    public suspend fun recoveryAzureStorageAccountId(`value`: Output<String>) {
        this.recoveryAzureStorageAccountId = value
    }

    /**
     * @param value The disk Uri.
     */
    @JvmName("janajdyxhuubotnq")
    public suspend fun diskUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskUri = mapped
    }

    /**
     * @param value The primary staging storage account Id.
     */
    @JvmName("krlgyjvgcouvhhnq")
    public suspend fun primaryStagingAzureStorageAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryStagingAzureStorageAccountId = mapped
    }

    /**
     * @param value The recovery VHD storage account Id.
     */
    @JvmName("mjqjgewogkqgcxkv")
    public suspend fun recoveryAzureStorageAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryAzureStorageAccountId = mapped
    }

    internal fun build(): A2AVmDiskInputDetailsArgs = A2AVmDiskInputDetailsArgs(
        diskUri = diskUri ?: throw PulumiNullFieldException("diskUri"),
        primaryStagingAzureStorageAccountId = primaryStagingAzureStorageAccountId ?: throw
            PulumiNullFieldException("primaryStagingAzureStorageAccountId"),
        recoveryAzureStorageAccountId = recoveryAzureStorageAccountId ?: throw
            PulumiNullFieldException("recoveryAzureStorageAccountId"),
    )
}
