@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AddRecoveryServicesProviderInputPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of an add provider request.
 * @property authenticationIdentityInput The identity provider input for DRA authentication.
 * @property biosId The Bios Id of the machine.
 * @property dataPlaneAuthenticationIdentityInput The identity provider input for data plane authentication.
 * @property machineId The Id of the machine where the provider is getting added.
 * @property machineName The name of the machine where the provider is getting added.
 * @property resourceAccessIdentityInput The identity provider input for resource access.
 */
public data class AddRecoveryServicesProviderInputPropertiesArgs(
    public val authenticationIdentityInput: Output<IdentityProviderInputArgs>,
    public val biosId: Output<String>? = null,
    public val dataPlaneAuthenticationIdentityInput: Output<IdentityProviderInputArgs>? = null,
    public val machineId: Output<String>? = null,
    public val machineName: Output<String>,
    public val resourceAccessIdentityInput: Output<IdentityProviderInputArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AddRecoveryServicesProviderInputPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AddRecoveryServicesProviderInputPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AddRecoveryServicesProviderInputPropertiesArgs.builder()
            .authenticationIdentityInput(
                authenticationIdentityInput.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .biosId(biosId?.applyValue({ args0 -> args0 }))
            .dataPlaneAuthenticationIdentityInput(
                dataPlaneAuthenticationIdentityInput?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .machineId(machineId?.applyValue({ args0 -> args0 }))
            .machineName(machineName.applyValue({ args0 -> args0 }))
            .resourceAccessIdentityInput(
                resourceAccessIdentityInput.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AddRecoveryServicesProviderInputPropertiesArgs].
 */
@PulumiTagMarker
public class AddRecoveryServicesProviderInputPropertiesArgsBuilder internal constructor() {
    private var authenticationIdentityInput: Output<IdentityProviderInputArgs>? = null

    private var biosId: Output<String>? = null

    private var dataPlaneAuthenticationIdentityInput: Output<IdentityProviderInputArgs>? = null

    private var machineId: Output<String>? = null

    private var machineName: Output<String>? = null

    private var resourceAccessIdentityInput: Output<IdentityProviderInputArgs>? = null

    /**
     * @param value The identity provider input for DRA authentication.
     */
    @JvmName("hhimrhcxrrfsdbhi")
    public suspend fun authenticationIdentityInput(`value`: Output<IdentityProviderInputArgs>) {
        this.authenticationIdentityInput = value
    }

    /**
     * @param value The Bios Id of the machine.
     */
    @JvmName("ggmhvoutvsiaiewm")
    public suspend fun biosId(`value`: Output<String>) {
        this.biosId = value
    }

    /**
     * @param value The identity provider input for data plane authentication.
     */
    @JvmName("csempsfcepciyhbr")
    public suspend
    fun dataPlaneAuthenticationIdentityInput(`value`: Output<IdentityProviderInputArgs>) {
        this.dataPlaneAuthenticationIdentityInput = value
    }

    /**
     * @param value The Id of the machine where the provider is getting added.
     */
    @JvmName("knlgfaswpquikbgx")
    public suspend fun machineId(`value`: Output<String>) {
        this.machineId = value
    }

    /**
     * @param value The name of the machine where the provider is getting added.
     */
    @JvmName("hxoogxluogxxnuyg")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value The identity provider input for resource access.
     */
    @JvmName("osdeumulqtvoqgno")
    public suspend fun resourceAccessIdentityInput(`value`: Output<IdentityProviderInputArgs>) {
        this.resourceAccessIdentityInput = value
    }

    /**
     * @param value The identity provider input for DRA authentication.
     */
    @JvmName("yryfujrclyhdnlmx")
    public suspend fun authenticationIdentityInput(`value`: IdentityProviderInputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationIdentityInput = mapped
    }

    /**
     * @param argument The identity provider input for DRA authentication.
     */
    @JvmName("ivaotknumistheal")
    public suspend
    fun authenticationIdentityInput(argument: suspend IdentityProviderInputArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityProviderInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authenticationIdentityInput = mapped
    }

    /**
     * @param value The Bios Id of the machine.
     */
    @JvmName("ytemslnngosrqwfi")
    public suspend fun biosId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.biosId = mapped
    }

    /**
     * @param value The identity provider input for data plane authentication.
     */
    @JvmName("trauyovgtvbldero")
    public suspend fun dataPlaneAuthenticationIdentityInput(`value`: IdentityProviderInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPlaneAuthenticationIdentityInput = mapped
    }

    /**
     * @param argument The identity provider input for data plane authentication.
     */
    @JvmName("dqsdkdyiojketlon")
    public suspend
    fun dataPlaneAuthenticationIdentityInput(argument: suspend IdentityProviderInputArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityProviderInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataPlaneAuthenticationIdentityInput = mapped
    }

    /**
     * @param value The Id of the machine where the provider is getting added.
     */
    @JvmName("jiiglfbymllxitir")
    public suspend fun machineId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineId = mapped
    }

    /**
     * @param value The name of the machine where the provider is getting added.
     */
    @JvmName("knxsypedqghhsqev")
    public suspend fun machineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value The identity provider input for resource access.
     */
    @JvmName("iyjevpesgtboajcp")
    public suspend fun resourceAccessIdentityInput(`value`: IdentityProviderInputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAccessIdentityInput = mapped
    }

    /**
     * @param argument The identity provider input for resource access.
     */
    @JvmName("bicnupcwxsukeala")
    public suspend
    fun resourceAccessIdentityInput(argument: suspend IdentityProviderInputArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityProviderInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceAccessIdentityInput = mapped
    }

    internal fun build(): AddRecoveryServicesProviderInputPropertiesArgs =
        AddRecoveryServicesProviderInputPropertiesArgs(
            authenticationIdentityInput = authenticationIdentityInput ?: throw
                PulumiNullFieldException("authenticationIdentityInput"),
            biosId = biosId,
            dataPlaneAuthenticationIdentityInput = dataPlaneAuthenticationIdentityInput,
            machineId = machineId,
            machineName = machineName ?: throw PulumiNullFieldException("machineName"),
            resourceAccessIdentityInput = resourceAccessIdentityInput ?: throw
                PulumiNullFieldException("resourceAccessIdentityInput"),
        )
}
