@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureBackupServerContainerArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.BackupManagementType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * AzureBackupServer (DPMVenus) workload-specific protection container.
 * @property backupManagementType Type of backup management for the container.
 * @property canReRegister Specifies whether the container is re-registrable.
 * @property containerId ID of container.
 * @property containerType Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
 * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
 * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
 * Backup is VMAppContainer
 * Expected value is 'AzureBackupServerContainer'.
 * @property dpmAgentVersion Backup engine Agent version
 * @property dpmServers List of BackupEngines protecting the container
 * @property extendedInfo Extended Info of the container.
 * @property friendlyName Friendly name of the container.
 * @property healthStatus Status of health of the container.
 * @property protectableObjectType Type of the protectable object associated with this container
 * @property protectedItemCount Number of protected items in the BackupEngine
 * @property protectionStatus Protection status of the container.
 * @property registrationStatus Status of registration of the container with the Recovery Services Vault.
 * @property upgradeAvailable To check if upgrade available
 */
public data class AzureBackupServerContainerArgs(
    public val backupManagementType: Output<Either<String, BackupManagementType>>? = null,
    public val canReRegister: Output<Boolean>? = null,
    public val containerId: Output<String>? = null,
    public val containerType: Output<String>,
    public val dpmAgentVersion: Output<String>? = null,
    public val dpmServers: Output<List<String>>? = null,
    public val extendedInfo: Output<DPMContainerExtendedInfoArgs>? = null,
    public val friendlyName: Output<String>? = null,
    public val healthStatus: Output<String>? = null,
    public val protectableObjectType: Output<String>? = null,
    public val protectedItemCount: Output<Double>? = null,
    public val protectionStatus: Output<String>? = null,
    public val registrationStatus: Output<String>? = null,
    public val upgradeAvailable: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureBackupServerContainerArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureBackupServerContainerArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureBackupServerContainerArgs.builder()
            .backupManagementType(
                backupManagementType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .canReRegister(canReRegister?.applyValue({ args0 -> args0 }))
            .containerId(containerId?.applyValue({ args0 -> args0 }))
            .containerType(containerType.applyValue({ args0 -> args0 }))
            .dpmAgentVersion(dpmAgentVersion?.applyValue({ args0 -> args0 }))
            .dpmServers(dpmServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .extendedInfo(extendedInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .healthStatus(healthStatus?.applyValue({ args0 -> args0 }))
            .protectableObjectType(protectableObjectType?.applyValue({ args0 -> args0 }))
            .protectedItemCount(protectedItemCount?.applyValue({ args0 -> args0 }))
            .protectionStatus(protectionStatus?.applyValue({ args0 -> args0 }))
            .registrationStatus(registrationStatus?.applyValue({ args0 -> args0 }))
            .upgradeAvailable(upgradeAvailable?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureBackupServerContainerArgs].
 */
@PulumiTagMarker
public class AzureBackupServerContainerArgsBuilder internal constructor() {
    private var backupManagementType: Output<Either<String, BackupManagementType>>? = null

    private var canReRegister: Output<Boolean>? = null

    private var containerId: Output<String>? = null

    private var containerType: Output<String>? = null

    private var dpmAgentVersion: Output<String>? = null

    private var dpmServers: Output<List<String>>? = null

    private var extendedInfo: Output<DPMContainerExtendedInfoArgs>? = null

    private var friendlyName: Output<String>? = null

    private var healthStatus: Output<String>? = null

    private var protectableObjectType: Output<String>? = null

    private var protectedItemCount: Output<Double>? = null

    private var protectionStatus: Output<String>? = null

    private var registrationStatus: Output<String>? = null

    private var upgradeAvailable: Output<Boolean>? = null

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("dpyhatoqgdgvshkk")
    public suspend fun backupManagementType(`value`: Output<Either<String, BackupManagementType>>) {
        this.backupManagementType = value
    }

    /**
     * @param value Specifies whether the container is re-registrable.
     */
    @JvmName("kbmgootsmbnmwhpm")
    public suspend fun canReRegister(`value`: Output<Boolean>) {
        this.canReRegister = value
    }

    /**
     * @param value ID of container.
     */
    @JvmName("vghnqqoaoqmuosuw")
    public suspend fun containerId(`value`: Output<String>) {
        this.containerId = value
    }

    /**
     * @param value Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
     * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
     * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
     * Backup is VMAppContainer
     * Expected value is 'AzureBackupServerContainer'.
     */
    @JvmName("pcklotlpiouetqkx")
    public suspend fun containerType(`value`: Output<String>) {
        this.containerType = value
    }

    /**
     * @param value Backup engine Agent version
     */
    @JvmName("mnpwhbkfshhnqmqf")
    public suspend fun dpmAgentVersion(`value`: Output<String>) {
        this.dpmAgentVersion = value
    }

    /**
     * @param value List of BackupEngines protecting the container
     */
    @JvmName("curgwdalxlohlmxp")
    public suspend fun dpmServers(`value`: Output<List<String>>) {
        this.dpmServers = value
    }

    @JvmName("tmyoaegslhvxfnao")
    public suspend fun dpmServers(vararg values: Output<String>) {
        this.dpmServers = Output.all(values.asList())
    }

    /**
     * @param values List of BackupEngines protecting the container
     */
    @JvmName("tkhiyjfxxrmjvawn")
    public suspend fun dpmServers(values: List<Output<String>>) {
        this.dpmServers = Output.all(values)
    }

    /**
     * @param value Extended Info of the container.
     */
    @JvmName("ikisqfmcavkuudkt")
    public suspend fun extendedInfo(`value`: Output<DPMContainerExtendedInfoArgs>) {
        this.extendedInfo = value
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("pjmcdfsdpfufaktf")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Status of health of the container.
     */
    @JvmName("ecuwfmlyjsuiaohq")
    public suspend fun healthStatus(`value`: Output<String>) {
        this.healthStatus = value
    }

    /**
     * @param value Type of the protectable object associated with this container
     */
    @JvmName("yogdqdssoxhbwqjt")
    public suspend fun protectableObjectType(`value`: Output<String>) {
        this.protectableObjectType = value
    }

    /**
     * @param value Number of protected items in the BackupEngine
     */
    @JvmName("vprreysrwkwrdhur")
    public suspend fun protectedItemCount(`value`: Output<Double>) {
        this.protectedItemCount = value
    }

    /**
     * @param value Protection status of the container.
     */
    @JvmName("kpkrbenadfqnyndl")
    public suspend fun protectionStatus(`value`: Output<String>) {
        this.protectionStatus = value
    }

    /**
     * @param value Status of registration of the container with the Recovery Services Vault.
     */
    @JvmName("yqttfvequvgwpbgk")
    public suspend fun registrationStatus(`value`: Output<String>) {
        this.registrationStatus = value
    }

    /**
     * @param value To check if upgrade available
     */
    @JvmName("kxugexprwgtbeueb")
    public suspend fun upgradeAvailable(`value`: Output<Boolean>) {
        this.upgradeAvailable = value
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("tuteqgpvjjoeogme")
    public suspend fun backupManagementType(`value`: Either<String, BackupManagementType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("peqhlnkamcnhuiej")
    public fun backupManagementType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("mshpxonryibtudar")
    public fun backupManagementType(`value`: BackupManagementType) {
        val toBeMapped = Either.ofRight<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Specifies whether the container is re-registrable.
     */
    @JvmName("smxnjykfppkjaoxw")
    public suspend fun canReRegister(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canReRegister = mapped
    }

    /**
     * @param value ID of container.
     */
    @JvmName("dwbikhnwqmqcviab")
    public suspend fun containerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerId = mapped
    }

    /**
     * @param value Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
     * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
     * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
     * Backup is VMAppContainer
     * Expected value is 'AzureBackupServerContainer'.
     */
    @JvmName("qkiirvxhadnefmma")
    public suspend fun containerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerType = mapped
    }

    /**
     * @param value Backup engine Agent version
     */
    @JvmName("qsqrjftoactmpwih")
    public suspend fun dpmAgentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dpmAgentVersion = mapped
    }

    /**
     * @param value List of BackupEngines protecting the container
     */
    @JvmName("wgykbemgeepnswtd")
    public suspend fun dpmServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dpmServers = mapped
    }

    /**
     * @param values List of BackupEngines protecting the container
     */
    @JvmName("xaffgyqqubmaaksg")
    public suspend fun dpmServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dpmServers = mapped
    }

    /**
     * @param value Extended Info of the container.
     */
    @JvmName("euhpodwqtqgixseg")
    public suspend fun extendedInfo(`value`: DPMContainerExtendedInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedInfo = mapped
    }

    /**
     * @param argument Extended Info of the container.
     */
    @JvmName("uaisnjleuxjeefsm")
    public suspend
    fun extendedInfo(argument: suspend DPMContainerExtendedInfoArgsBuilder.() -> Unit) {
        val toBeMapped = DPMContainerExtendedInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedInfo = mapped
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("nnuagpmcmuolenyf")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Status of health of the container.
     */
    @JvmName("kxgoatffvkvntuno")
    public suspend fun healthStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthStatus = mapped
    }

    /**
     * @param value Type of the protectable object associated with this container
     */
    @JvmName("nbjkapwvgvoxnsyi")
    public suspend fun protectableObjectType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectableObjectType = mapped
    }

    /**
     * @param value Number of protected items in the BackupEngine
     */
    @JvmName("mtvpavumfghptdsd")
    public suspend fun protectedItemCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemCount = mapped
    }

    /**
     * @param value Protection status of the container.
     */
    @JvmName("lmvxeemagqbndpty")
    public suspend fun protectionStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionStatus = mapped
    }

    /**
     * @param value Status of registration of the container with the Recovery Services Vault.
     */
    @JvmName("pqtqtdporjjgxwnm")
    public suspend fun registrationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationStatus = mapped
    }

    /**
     * @param value To check if upgrade available
     */
    @JvmName("nnfxamoannjrhjyw")
    public suspend fun upgradeAvailable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeAvailable = mapped
    }

    internal fun build(): AzureBackupServerContainerArgs = AzureBackupServerContainerArgs(
        backupManagementType = backupManagementType,
        canReRegister = canReRegister,
        containerId = containerId,
        containerType = containerType ?: throw PulumiNullFieldException("containerType"),
        dpmAgentVersion = dpmAgentVersion,
        dpmServers = dpmServers,
        extendedInfo = extendedInfo,
        friendlyName = friendlyName,
        healthStatus = healthStatus,
        protectableObjectType = protectableObjectType,
        protectedItemCount = protectedItemCount,
        protectionStatus = protectionStatus,
        registrationStatus = registrationStatus,
        upgradeAvailable = upgradeAvailable,
    )
}
