@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureFileShareProtectionPolicyArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.WorkloadType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * AzureStorage backup policy.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'AzureStorage'.
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property retentionPolicy Retention policy with the details on backup copy retention ranges.
 * @property schedulePolicy Backup schedule specified as part of backup policy.
 * @property timeZone TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
 * @property workLoadType Type of workload for the backup management
 */
public data class AzureFileShareProtectionPolicyArgs(
    public val backupManagementType: Output<String>,
    public val protectedItemsCount: Output<Int>? = null,
    public val resourceGuardOperationRequests: Output<List<String>>? = null,
    public val retentionPolicy:
    Output<Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>>? = null,
    public val schedulePolicy: Output<Any>? = null,
    public val timeZone: Output<String>? = null,
    public val workLoadType: Output<Either<String, WorkloadType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureFileShareProtectionPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureFileShareProtectionPolicyArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureFileShareProtectionPolicyArgs.builder()
            .backupManagementType(backupManagementType.applyValue({ args0 -> args0 }))
            .protectedItemsCount(protectedItemsCount?.applyValue({ args0 -> args0 }))
            .resourceGuardOperationRequests(
                resourceGuardOperationRequests?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .retentionPolicy(
                retentionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .schedulePolicy(schedulePolicy?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 }))
            .workLoadType(
                workLoadType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureFileShareProtectionPolicyArgs].
 */
@PulumiTagMarker
public class AzureFileShareProtectionPolicyArgsBuilder internal constructor() {
    private var backupManagementType: Output<String>? = null

    private var protectedItemsCount: Output<Int>? = null

    private var resourceGuardOperationRequests: Output<List<String>>? = null

    private var retentionPolicy:
        Output<Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>>? = null

    private var schedulePolicy: Output<Any>? = null

    private var timeZone: Output<String>? = null

    private var workLoadType: Output<Either<String, WorkloadType>>? = null

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'AzureStorage'.
     */
    @JvmName("mkdfwuncqvucgysw")
    public suspend fun backupManagementType(`value`: Output<String>) {
        this.backupManagementType = value
    }

    /**
     * @param value Number of items associated with this policy.
     */
    @JvmName("mvummiemiufgapmw")
    public suspend fun protectedItemsCount(`value`: Output<Int>) {
        this.protectedItemsCount = value
    }

    /**
     * @param value ResourceGuard Operation Requests
     */
    @JvmName("overescsnplyfqyu")
    public suspend fun resourceGuardOperationRequests(`value`: Output<List<String>>) {
        this.resourceGuardOperationRequests = value
    }

    @JvmName("vndnndvedysaclwl")
    public suspend fun resourceGuardOperationRequests(vararg values: Output<String>) {
        this.resourceGuardOperationRequests = Output.all(values.asList())
    }

    /**
     * @param values ResourceGuard Operation Requests
     */
    @JvmName("xxicvndigsgyhkmc")
    public suspend fun resourceGuardOperationRequests(values: List<Output<String>>) {
        this.resourceGuardOperationRequests = Output.all(values)
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("fksbxnqovdbbgito")
    public suspend
    fun retentionPolicy(`value`: Output<Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>>) {
        this.retentionPolicy = value
    }

    /**
     * @param value Backup schedule specified as part of backup policy.
     */
    @JvmName("hrjjjnrvvwyuuttk")
    public suspend fun schedulePolicy(`value`: Output<Any>) {
        this.schedulePolicy = value
    }

    /**
     * @param value TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
     */
    @JvmName("afdkdsvhsyrkneoa")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Type of workload for the backup management
     */
    @JvmName("penxpniongudtonf")
    public suspend fun workLoadType(`value`: Output<Either<String, WorkloadType>>) {
        this.workLoadType = value
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'AzureStorage'.
     */
    @JvmName("jvborsuwptjwguaw")
    public suspend fun backupManagementType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Number of items associated with this policy.
     */
    @JvmName("tamqaupnsaauigep")
    public suspend fun protectedItemsCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemsCount = mapped
    }

    /**
     * @param value ResourceGuard Operation Requests
     */
    @JvmName("wxexsghogxcuoxid")
    public suspend fun resourceGuardOperationRequests(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param values ResourceGuard Operation Requests
     */
    @JvmName("qhyceelmbkptoyea")
    public suspend fun resourceGuardOperationRequests(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("sgnxtpmoojwfttnb")
    public suspend
    fun retentionPolicy(`value`: Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("isydfoypgeoosqnr")
    public fun retentionPolicy(`value`: LongTermRetentionPolicyArgs) {
        val toBeMapped = Either.ofLeft<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("wmpruagkugyipiuo")
    public fun retentionPolicy(`value`: SimpleRetentionPolicyArgs) {
        val toBeMapped = Either.ofRight<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param value Backup schedule specified as part of backup policy.
     */
    @JvmName("obepkcgbwfwpmtqm")
    public suspend fun schedulePolicy(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedulePolicy = mapped
    }

    /**
     * @param value TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
     */
    @JvmName("mtkfyvkibpxhhnsm")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    /**
     * @param value Type of workload for the backup management
     */
    @JvmName("yrxtcunruuyuuyao")
    public suspend fun workLoadType(`value`: Either<String, WorkloadType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workLoadType = mapped
    }

    /**
     * @param value Type of workload for the backup management
     */
    @JvmName("thnnxuolbgitjeeh")
    public fun workLoadType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workLoadType = mapped
    }

    /**
     * @param value Type of workload for the backup management
     */
    @JvmName("nejmwrumeqahawag")
    public fun workLoadType(`value`: WorkloadType) {
        val toBeMapped = Either.ofRight<String, WorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workLoadType = mapped
    }

    internal fun build(): AzureFileShareProtectionPolicyArgs = AzureFileShareProtectionPolicyArgs(
        backupManagementType = backupManagementType ?: throw
            PulumiNullFieldException("backupManagementType"),
        protectedItemsCount = protectedItemsCount,
        resourceGuardOperationRequests = resourceGuardOperationRequests,
        retentionPolicy = retentionPolicy,
        schedulePolicy = schedulePolicy,
        timeZone = timeZone,
        workLoadType = workLoadType,
    )
}
