@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureFileshareProtectedItemArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.CreateMode
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ProtectionState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure File Share workload-specific backup item.
 * @property backupSetName Name of the backup set the backup item belongs to
 * @property containerName Unique name of container
 * @property createMode Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
 * @property deferredDeleteTimeInUTC Time for deferred deletion in UTC
 * @property deferredDeleteTimeRemaining Time remaining before the DS marked for deferred delete is permanently deleted
 * @property extendedInfo Additional information with this backup item.
 * @property friendlyName Friendly name of the fileshare represented by this backup item.
 * @property isArchiveEnabled Flag to identify whether datasource is protected in archive
 * @property isDeferredDeleteScheduleUpcoming Flag to identify whether the deferred deleted DS is to be purged soon
 * @property isRehydrate Flag to identify that deferred deleted DS is to be moved into Pause state
 * @property isScheduledForDeferredDelete Flag to identify whether the DS is scheduled for deferred delete
 * @property kpisHealths Health details of different KPIs
 * @property lastBackupStatus Last backup operation status. Possible values: Healthy, Unhealthy.
 * @property lastBackupTime Timestamp of the last backup operation on this backup item.
 * @property lastRecoveryPoint Timestamp when the last (latest) backup copy was created for this backup item.
 * @property policyId ID of the backup policy with which this item is backed up.
 * @property policyName Name of the policy used for protection
 * @property protectedItemType backup item type.
 * Expected value is 'AzureFileShareProtectedItem'.
 * @property protectionState Backup state of this backup item.
 * @property protectionStatus Backup status of this backup item.
 * @property resourceGuardOperationRequests ResourceGuardOperationRequests on which LAC check will be performed
 * @property softDeleteRetentionPeriodInDays Soft delete retention period in days
 * @property sourceResourceId ARM ID of the resource to be backed up.
 */
public data class AzureFileshareProtectedItemArgs(
    public val backupSetName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val createMode: Output<Either<String, CreateMode>>? = null,
    public val deferredDeleteTimeInUTC: Output<String>? = null,
    public val deferredDeleteTimeRemaining: Output<String>? = null,
    public val extendedInfo: Output<AzureFileshareProtectedItemExtendedInfoArgs>? = null,
    public val friendlyName: Output<String>? = null,
    public val isArchiveEnabled: Output<Boolean>? = null,
    public val isDeferredDeleteScheduleUpcoming: Output<Boolean>? = null,
    public val isRehydrate: Output<Boolean>? = null,
    public val isScheduledForDeferredDelete: Output<Boolean>? = null,
    public val kpisHealths: Output<Map<String, KPIResourceHealthDetailsArgs>>? = null,
    public val lastBackupStatus: Output<String>? = null,
    public val lastBackupTime: Output<String>? = null,
    public val lastRecoveryPoint: Output<String>? = null,
    public val policyId: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val protectedItemType: Output<String>,
    public val protectionState: Output<Either<String, ProtectionState>>? = null,
    public val protectionStatus: Output<String>? = null,
    public val resourceGuardOperationRequests: Output<List<String>>? = null,
    public val softDeleteRetentionPeriodInDays: Output<Int>? = null,
    public val sourceResourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureFileshareProtectedItemArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureFileshareProtectedItemArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureFileshareProtectedItemArgs.builder()
            .backupSetName(backupSetName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .createMode(
                createMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deferredDeleteTimeInUTC(deferredDeleteTimeInUTC?.applyValue({ args0 -> args0 }))
            .deferredDeleteTimeRemaining(deferredDeleteTimeRemaining?.applyValue({ args0 -> args0 }))
            .extendedInfo(extendedInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .isArchiveEnabled(isArchiveEnabled?.applyValue({ args0 -> args0 }))
            .isDeferredDeleteScheduleUpcoming(isDeferredDeleteScheduleUpcoming?.applyValue({ args0 -> args0 }))
            .isRehydrate(isRehydrate?.applyValue({ args0 -> args0 }))
            .isScheduledForDeferredDelete(isScheduledForDeferredDelete?.applyValue({ args0 -> args0 }))
            .kpisHealths(
                kpisHealths?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .lastBackupStatus(lastBackupStatus?.applyValue({ args0 -> args0 }))
            .lastBackupTime(lastBackupTime?.applyValue({ args0 -> args0 }))
            .lastRecoveryPoint(lastRecoveryPoint?.applyValue({ args0 -> args0 }))
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .protectedItemType(protectedItemType.applyValue({ args0 -> args0 }))
            .protectionState(
                protectionState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .protectionStatus(protectionStatus?.applyValue({ args0 -> args0 }))
            .resourceGuardOperationRequests(
                resourceGuardOperationRequests?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .softDeleteRetentionPeriodInDays(softDeleteRetentionPeriodInDays?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFileshareProtectedItemArgs].
 */
@PulumiTagMarker
public class AzureFileshareProtectedItemArgsBuilder internal constructor() {
    private var backupSetName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var createMode: Output<Either<String, CreateMode>>? = null

    private var deferredDeleteTimeInUTC: Output<String>? = null

    private var deferredDeleteTimeRemaining: Output<String>? = null

    private var extendedInfo: Output<AzureFileshareProtectedItemExtendedInfoArgs>? = null

    private var friendlyName: Output<String>? = null

    private var isArchiveEnabled: Output<Boolean>? = null

    private var isDeferredDeleteScheduleUpcoming: Output<Boolean>? = null

    private var isRehydrate: Output<Boolean>? = null

    private var isScheduledForDeferredDelete: Output<Boolean>? = null

    private var kpisHealths: Output<Map<String, KPIResourceHealthDetailsArgs>>? = null

    private var lastBackupStatus: Output<String>? = null

    private var lastBackupTime: Output<String>? = null

    private var lastRecoveryPoint: Output<String>? = null

    private var policyId: Output<String>? = null

    private var policyName: Output<String>? = null

    private var protectedItemType: Output<String>? = null

    private var protectionState: Output<Either<String, ProtectionState>>? = null

    private var protectionStatus: Output<String>? = null

    private var resourceGuardOperationRequests: Output<List<String>>? = null

    private var softDeleteRetentionPeriodInDays: Output<Int>? = null

    private var sourceResourceId: Output<String>? = null

    /**
     * @param value Name of the backup set the backup item belongs to
     */
    @JvmName("qcuaonhpksaklkmj")
    public suspend fun backupSetName(`value`: Output<String>) {
        this.backupSetName = value
    }

    /**
     * @param value Unique name of container
     */
    @JvmName("vlpcrlyjdmgjyvym")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("dshdtrvievebwesk")
    public suspend fun createMode(`value`: Output<Either<String, CreateMode>>) {
        this.createMode = value
    }

    /**
     * @param value Time for deferred deletion in UTC
     */
    @JvmName("bvgucrxfpyumogpn")
    public suspend fun deferredDeleteTimeInUTC(`value`: Output<String>) {
        this.deferredDeleteTimeInUTC = value
    }

    /**
     * @param value Time remaining before the DS marked for deferred delete is permanently deleted
     */
    @JvmName("herbulstccvxldmk")
    public suspend fun deferredDeleteTimeRemaining(`value`: Output<String>) {
        this.deferredDeleteTimeRemaining = value
    }

    /**
     * @param value Additional information with this backup item.
     */
    @JvmName("cgxrxyolsteaknbc")
    public suspend fun extendedInfo(`value`: Output<AzureFileshareProtectedItemExtendedInfoArgs>) {
        this.extendedInfo = value
    }

    /**
     * @param value Friendly name of the fileshare represented by this backup item.
     */
    @JvmName("tbwmrpkehsfuyatk")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Flag to identify whether datasource is protected in archive
     */
    @JvmName("saiiktujlwhcakej")
    public suspend fun isArchiveEnabled(`value`: Output<Boolean>) {
        this.isArchiveEnabled = value
    }

    /**
     * @param value Flag to identify whether the deferred deleted DS is to be purged soon
     */
    @JvmName("kgbuugqdwjfdqbjk")
    public suspend fun isDeferredDeleteScheduleUpcoming(`value`: Output<Boolean>) {
        this.isDeferredDeleteScheduleUpcoming = value
    }

    /**
     * @param value Flag to identify that deferred deleted DS is to be moved into Pause state
     */
    @JvmName("oiqvechwjhslhexf")
    public suspend fun isRehydrate(`value`: Output<Boolean>) {
        this.isRehydrate = value
    }

    /**
     * @param value Flag to identify whether the DS is scheduled for deferred delete
     */
    @JvmName("tqeguomwpjuxiqir")
    public suspend fun isScheduledForDeferredDelete(`value`: Output<Boolean>) {
        this.isScheduledForDeferredDelete = value
    }

    /**
     * @param value Health details of different KPIs
     */
    @JvmName("mkysfqcqsigvsjxi")
    public suspend fun kpisHealths(`value`: Output<Map<String, KPIResourceHealthDetailsArgs>>) {
        this.kpisHealths = value
    }

    /**
     * @param value Last backup operation status. Possible values: Healthy, Unhealthy.
     */
    @JvmName("ctkndwxfaxjpgitw")
    public suspend fun lastBackupStatus(`value`: Output<String>) {
        this.lastBackupStatus = value
    }

    /**
     * @param value Timestamp of the last backup operation on this backup item.
     */
    @JvmName("jvvppqqigofhqoee")
    public suspend fun lastBackupTime(`value`: Output<String>) {
        this.lastBackupTime = value
    }

    /**
     * @param value Timestamp when the last (latest) backup copy was created for this backup item.
     */
    @JvmName("myepolcqiomhnbli")
    public suspend fun lastRecoveryPoint(`value`: Output<String>) {
        this.lastRecoveryPoint = value
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("pjyxqumvwsatcarj")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value Name of the policy used for protection
     */
    @JvmName("wpcjpnbmoouhrwvm")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value backup item type.
     * Expected value is 'AzureFileShareProtectedItem'.
     */
    @JvmName("thnnwbreqdsisnmw")
    public suspend fun protectedItemType(`value`: Output<String>) {
        this.protectedItemType = value
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("cdphuxrlodkghddv")
    public suspend fun protectionState(`value`: Output<Either<String, ProtectionState>>) {
        this.protectionState = value
    }

    /**
     * @param value Backup status of this backup item.
     */
    @JvmName("vngkiufogbwddgck")
    public suspend fun protectionStatus(`value`: Output<String>) {
        this.protectionStatus = value
    }

    /**
     * @param value ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("xivvkybvxradltuc")
    public suspend fun resourceGuardOperationRequests(`value`: Output<List<String>>) {
        this.resourceGuardOperationRequests = value
    }

    @JvmName("ocvsfemgpgfgwytl")
    public suspend fun resourceGuardOperationRequests(vararg values: Output<String>) {
        this.resourceGuardOperationRequests = Output.all(values.asList())
    }

    /**
     * @param values ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("wkxbmwovgxpwmlfe")
    public suspend fun resourceGuardOperationRequests(values: List<Output<String>>) {
        this.resourceGuardOperationRequests = Output.all(values)
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("iweegednncxflemp")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Output<Int>) {
        this.softDeleteRetentionPeriodInDays = value
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("txenkjuwotmivoam")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Name of the backup set the backup item belongs to
     */
    @JvmName("pmojniixumtpjler")
    public suspend fun backupSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupSetName = mapped
    }

    /**
     * @param value Unique name of container
     */
    @JvmName("utouiqhrnnnmpcwo")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("tnjuwdrdysbvipvw")
    public suspend fun createMode(`value`: Either<String, CreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("gxpabhojxyopxarv")
    public fun createMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("clgvibvvmydkburm")
    public fun createMode(`value`: CreateMode) {
        val toBeMapped = Either.ofRight<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Time for deferred deletion in UTC
     */
    @JvmName("oppwfbkhjgchnbev")
    public suspend fun deferredDeleteTimeInUTC(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteTimeInUTC = mapped
    }

    /**
     * @param value Time remaining before the DS marked for deferred delete is permanently deleted
     */
    @JvmName("ddaaoeqnbboebuih")
    public suspend fun deferredDeleteTimeRemaining(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteTimeRemaining = mapped
    }

    /**
     * @param value Additional information with this backup item.
     */
    @JvmName("lquefurcmnynmenr")
    public suspend fun extendedInfo(`value`: AzureFileshareProtectedItemExtendedInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedInfo = mapped
    }

    /**
     * @param argument Additional information with this backup item.
     */
    @JvmName("thscmjqgykruoxsb")
    public suspend
    fun extendedInfo(argument: suspend AzureFileshareProtectedItemExtendedInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFileshareProtectedItemExtendedInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extendedInfo = mapped
    }

    /**
     * @param value Friendly name of the fileshare represented by this backup item.
     */
    @JvmName("uicuvmlcghwiofcn")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Flag to identify whether datasource is protected in archive
     */
    @JvmName("temeqrusgloivscc")
    public suspend fun isArchiveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchiveEnabled = mapped
    }

    /**
     * @param value Flag to identify whether the deferred deleted DS is to be purged soon
     */
    @JvmName("nqjjnjnpnsbeieof")
    public suspend fun isDeferredDeleteScheduleUpcoming(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDeferredDeleteScheduleUpcoming = mapped
    }

    /**
     * @param value Flag to identify that deferred deleted DS is to be moved into Pause state
     */
    @JvmName("qwgwjqnccscpkfps")
    public suspend fun isRehydrate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRehydrate = mapped
    }

    /**
     * @param value Flag to identify whether the DS is scheduled for deferred delete
     */
    @JvmName("okvmlcxlmpehxjpm")
    public suspend fun isScheduledForDeferredDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isScheduledForDeferredDelete = mapped
    }

    /**
     * @param value Health details of different KPIs
     */
    @JvmName("pmogdtksrtiwipfn")
    public suspend fun kpisHealths(`value`: Map<String, KPIResourceHealthDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kpisHealths = mapped
    }

    /**
     * @param argument Health details of different KPIs
     */
    @JvmName("pxaignufmkmbtxpc")
    public suspend fun kpisHealths(
        vararg
        argument: Pair<String, suspend KPIResourceHealthDetailsArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                KPIResourceHealthDetailsArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.kpisHealths = mapped
    }

    /**
     * @param values Health details of different KPIs
     */
    @JvmName("srbynlwgrvedsrcs")
    public fun kpisHealths(vararg values: Pair<String, KPIResourceHealthDetailsArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kpisHealths = mapped
    }

    /**
     * @param value Last backup operation status. Possible values: Healthy, Unhealthy.
     */
    @JvmName("flhlhukutrasacvc")
    public suspend fun lastBackupStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastBackupStatus = mapped
    }

    /**
     * @param value Timestamp of the last backup operation on this backup item.
     */
    @JvmName("raiqldtiradpmdyt")
    public suspend fun lastBackupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastBackupTime = mapped
    }

    /**
     * @param value Timestamp when the last (latest) backup copy was created for this backup item.
     */
    @JvmName("hdcukuxcoxgmidvf")
    public suspend fun lastRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastRecoveryPoint = mapped
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("tflcnacjyprywuvx")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value Name of the policy used for protection
     */
    @JvmName("ydvyryfcakckxpii")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value backup item type.
     * Expected value is 'AzureFileShareProtectedItem'.
     */
    @JvmName("xndnuqmgoefsfbgg")
    public suspend fun protectedItemType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedItemType = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("xjmwurgnxudmlvnd")
    public suspend fun protectionState(`value`: Either<String, ProtectionState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("luwsolouainugopj")
    public fun protectionState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtectionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("fmxlksjoioniqxlb")
    public fun protectionState(`value`: ProtectionState) {
        val toBeMapped = Either.ofRight<String, ProtectionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup status of this backup item.
     */
    @JvmName("orqdxyhseejomdox")
    public suspend fun protectionStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionStatus = mapped
    }

    /**
     * @param value ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("nyxobgobmmkrmtpu")
    public suspend fun resourceGuardOperationRequests(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param values ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("hawejvnlyvnijhyh")
    public suspend fun resourceGuardOperationRequests(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("efknhwuasndilmmu")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteRetentionPeriodInDays = mapped
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("bpgwreeyfyfxflmc")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    internal fun build(): AzureFileshareProtectedItemArgs = AzureFileshareProtectedItemArgs(
        backupSetName = backupSetName,
        containerName = containerName,
        createMode = createMode,
        deferredDeleteTimeInUTC = deferredDeleteTimeInUTC,
        deferredDeleteTimeRemaining = deferredDeleteTimeRemaining,
        extendedInfo = extendedInfo,
        friendlyName = friendlyName,
        isArchiveEnabled = isArchiveEnabled,
        isDeferredDeleteScheduleUpcoming = isDeferredDeleteScheduleUpcoming,
        isRehydrate = isRehydrate,
        isScheduledForDeferredDelete = isScheduledForDeferredDelete,
        kpisHealths = kpisHealths,
        lastBackupStatus = lastBackupStatus,
        lastBackupTime = lastBackupTime,
        lastRecoveryPoint = lastRecoveryPoint,
        policyId = policyId,
        policyName = policyName,
        protectedItemType = protectedItemType ?: throw PulumiNullFieldException("protectedItemType"),
        protectionState = protectionState,
        protectionStatus = protectionStatus,
        resourceGuardOperationRequests = resourceGuardOperationRequests,
        softDeleteRetentionPeriodInDays = softDeleteRetentionPeriodInDays,
        sourceResourceId = sourceResourceId,
    )
}
