@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSVMProtectedItemExtendedInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional information on Azure IaaS VM specific backup item.
 * @property newestRecoveryPointInArchive The latest backup copy available for this backup item in archive tier
 * @property oldestRecoveryPoint The oldest backup copy available for this backup item across all tiers.
 * @property oldestRecoveryPointInArchive The oldest backup copy available for this backup item in archive tier
 * @property oldestRecoveryPointInVault The oldest backup copy available for this backup item in vault tier
 * @property policyInconsistent Specifies if backup policy associated with the backup item is inconsistent.
 * @property recoveryPointCount Number of backup copies available for this backup item.
 */
public data class AzureIaaSVMProtectedItemExtendedInfoArgs(
    public val newestRecoveryPointInArchive: Output<String>? = null,
    public val oldestRecoveryPoint: Output<String>? = null,
    public val oldestRecoveryPointInArchive: Output<String>? = null,
    public val oldestRecoveryPointInVault: Output<String>? = null,
    public val policyInconsistent: Output<Boolean>? = null,
    public val recoveryPointCount: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSVMProtectedItemExtendedInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSVMProtectedItemExtendedInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSVMProtectedItemExtendedInfoArgs.builder()
            .newestRecoveryPointInArchive(newestRecoveryPointInArchive?.applyValue({ args0 -> args0 }))
            .oldestRecoveryPoint(oldestRecoveryPoint?.applyValue({ args0 -> args0 }))
            .oldestRecoveryPointInArchive(oldestRecoveryPointInArchive?.applyValue({ args0 -> args0 }))
            .oldestRecoveryPointInVault(oldestRecoveryPointInVault?.applyValue({ args0 -> args0 }))
            .policyInconsistent(policyInconsistent?.applyValue({ args0 -> args0 }))
            .recoveryPointCount(recoveryPointCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureIaaSVMProtectedItemExtendedInfoArgs].
 */
@PulumiTagMarker
public class AzureIaaSVMProtectedItemExtendedInfoArgsBuilder internal constructor() {
    private var newestRecoveryPointInArchive: Output<String>? = null

    private var oldestRecoveryPoint: Output<String>? = null

    private var oldestRecoveryPointInArchive: Output<String>? = null

    private var oldestRecoveryPointInVault: Output<String>? = null

    private var policyInconsistent: Output<Boolean>? = null

    private var recoveryPointCount: Output<Int>? = null

    /**
     * @param value The latest backup copy available for this backup item in archive tier
     */
    @JvmName("vqwcmoqvaqdsvmhq")
    public suspend fun newestRecoveryPointInArchive(`value`: Output<String>) {
        this.newestRecoveryPointInArchive = value
    }

    /**
     * @param value The oldest backup copy available for this backup item across all tiers.
     */
    @JvmName("isgvkrgaigbxtakv")
    public suspend fun oldestRecoveryPoint(`value`: Output<String>) {
        this.oldestRecoveryPoint = value
    }

    /**
     * @param value The oldest backup copy available for this backup item in archive tier
     */
    @JvmName("qippslmphnuxdqla")
    public suspend fun oldestRecoveryPointInArchive(`value`: Output<String>) {
        this.oldestRecoveryPointInArchive = value
    }

    /**
     * @param value The oldest backup copy available for this backup item in vault tier
     */
    @JvmName("qxthclleyioourmr")
    public suspend fun oldestRecoveryPointInVault(`value`: Output<String>) {
        this.oldestRecoveryPointInVault = value
    }

    /**
     * @param value Specifies if backup policy associated with the backup item is inconsistent.
     */
    @JvmName("bcogsknllpuxqitn")
    public suspend fun policyInconsistent(`value`: Output<Boolean>) {
        this.policyInconsistent = value
    }

    /**
     * @param value Number of backup copies available for this backup item.
     */
    @JvmName("yfuvmwarcmudnvnc")
    public suspend fun recoveryPointCount(`value`: Output<Int>) {
        this.recoveryPointCount = value
    }

    /**
     * @param value The latest backup copy available for this backup item in archive tier
     */
    @JvmName("jdogyvkuxpootdmj")
    public suspend fun newestRecoveryPointInArchive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newestRecoveryPointInArchive = mapped
    }

    /**
     * @param value The oldest backup copy available for this backup item across all tiers.
     */
    @JvmName("xtfhcgcvcoyuwdss")
    public suspend fun oldestRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oldestRecoveryPoint = mapped
    }

    /**
     * @param value The oldest backup copy available for this backup item in archive tier
     */
    @JvmName("mkecmwuaqntyrrfu")
    public suspend fun oldestRecoveryPointInArchive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oldestRecoveryPointInArchive = mapped
    }

    /**
     * @param value The oldest backup copy available for this backup item in vault tier
     */
    @JvmName("bunikwtfextqeexc")
    public suspend fun oldestRecoveryPointInVault(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oldestRecoveryPointInVault = mapped
    }

    /**
     * @param value Specifies if backup policy associated with the backup item is inconsistent.
     */
    @JvmName("maimjtidxxoaqrqf")
    public suspend fun policyInconsistent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyInconsistent = mapped
    }

    /**
     * @param value Number of backup copies available for this backup item.
     */
    @JvmName("lsltbsxordgocuss")
    public suspend fun recoveryPointCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPointCount = mapped
    }

    internal fun build(): AzureIaaSVMProtectedItemExtendedInfoArgs =
        AzureIaaSVMProtectedItemExtendedInfoArgs(
            newestRecoveryPointInArchive = newestRecoveryPointInArchive,
            oldestRecoveryPoint = oldestRecoveryPoint,
            oldestRecoveryPointInArchive = oldestRecoveryPointInArchive,
            oldestRecoveryPointInVault = oldestRecoveryPointInVault,
            policyInconsistent = policyInconsistent,
            recoveryPointCount = recoveryPointCount,
        )
}
