@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureVmWorkloadProtectionPolicyArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.WorkloadType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure VM (Mercury) workload-specific backup policy.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'AzureWorkload'.
 * @property makePolicyConsistent Fix the policy inconsistency
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property settings Common settings for the backup management
 * @property subProtectionPolicy List of sub-protection policies which includes schedule and retention
 * @property workLoadType Type of workload for the backup management
 */
public data class AzureVmWorkloadProtectionPolicyArgs(
    public val backupManagementType: Output<String>,
    public val makePolicyConsistent: Output<Boolean>? = null,
    public val protectedItemsCount: Output<Int>? = null,
    public val resourceGuardOperationRequests: Output<List<String>>? = null,
    public val settings: Output<SettingsArgs>? = null,
    public val subProtectionPolicy: Output<List<SubProtectionPolicyArgs>>? = null,
    public val workLoadType: Output<Either<String, WorkloadType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureVmWorkloadProtectionPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureVmWorkloadProtectionPolicyArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureVmWorkloadProtectionPolicyArgs.builder()
            .backupManagementType(backupManagementType.applyValue({ args0 -> args0 }))
            .makePolicyConsistent(makePolicyConsistent?.applyValue({ args0 -> args0 }))
            .protectedItemsCount(protectedItemsCount?.applyValue({ args0 -> args0 }))
            .resourceGuardOperationRequests(
                resourceGuardOperationRequests?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subProtectionPolicy(
                subProtectionPolicy?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .workLoadType(
                workLoadType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureVmWorkloadProtectionPolicyArgs].
 */
@PulumiTagMarker
public class AzureVmWorkloadProtectionPolicyArgsBuilder internal constructor() {
    private var backupManagementType: Output<String>? = null

    private var makePolicyConsistent: Output<Boolean>? = null

    private var protectedItemsCount: Output<Int>? = null

    private var resourceGuardOperationRequests: Output<List<String>>? = null

    private var settings: Output<SettingsArgs>? = null

    private var subProtectionPolicy: Output<List<SubProtectionPolicyArgs>>? = null

    private var workLoadType: Output<Either<String, WorkloadType>>? = null

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'AzureWorkload'.
     */
    @JvmName("wglbsersuxhkpeyl")
    public suspend fun backupManagementType(`value`: Output<String>) {
        this.backupManagementType = value
    }

    /**
     * @param value Fix the policy inconsistency
     */
    @JvmName("jijgutoptpklkaju")
    public suspend fun makePolicyConsistent(`value`: Output<Boolean>) {
        this.makePolicyConsistent = value
    }

    /**
     * @param value Number of items associated with this policy.
     */
    @JvmName("cnvqilpnpabrrgxb")
    public suspend fun protectedItemsCount(`value`: Output<Int>) {
        this.protectedItemsCount = value
    }

    /**
     * @param value ResourceGuard Operation Requests
     */
    @JvmName("illtxtutfbenkbwl")
    public suspend fun resourceGuardOperationRequests(`value`: Output<List<String>>) {
        this.resourceGuardOperationRequests = value
    }

    @JvmName("roybdxsepodwwbqi")
    public suspend fun resourceGuardOperationRequests(vararg values: Output<String>) {
        this.resourceGuardOperationRequests = Output.all(values.asList())
    }

    /**
     * @param values ResourceGuard Operation Requests
     */
    @JvmName("wcylbdnvknrylmku")
    public suspend fun resourceGuardOperationRequests(values: List<Output<String>>) {
        this.resourceGuardOperationRequests = Output.all(values)
    }

    /**
     * @param value Common settings for the backup management
     */
    @JvmName("vlggrueythstfhbq")
    public suspend fun settings(`value`: Output<SettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value List of sub-protection policies which includes schedule and retention
     */
    @JvmName("stqtasgwklamjabq")
    public suspend fun subProtectionPolicy(`value`: Output<List<SubProtectionPolicyArgs>>) {
        this.subProtectionPolicy = value
    }

    @JvmName("xviecivjfmqxwyrc")
    public suspend fun subProtectionPolicy(vararg values: Output<SubProtectionPolicyArgs>) {
        this.subProtectionPolicy = Output.all(values.asList())
    }

    /**
     * @param values List of sub-protection policies which includes schedule and retention
     */
    @JvmName("tqjrllndpphsilie")
    public suspend fun subProtectionPolicy(values: List<Output<SubProtectionPolicyArgs>>) {
        this.subProtectionPolicy = Output.all(values)
    }

    /**
     * @param value Type of workload for the backup management
     */
    @JvmName("nebirpcdqtpktiuh")
    public suspend fun workLoadType(`value`: Output<Either<String, WorkloadType>>) {
        this.workLoadType = value
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'AzureWorkload'.
     */
    @JvmName("vkbxfpsnqgmlokqx")
    public suspend fun backupManagementType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Fix the policy inconsistency
     */
    @JvmName("kibuduivbacojnof")
    public suspend fun makePolicyConsistent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.makePolicyConsistent = mapped
    }

    /**
     * @param value Number of items associated with this policy.
     */
    @JvmName("usuohuqhorfvhwjt")
    public suspend fun protectedItemsCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemsCount = mapped
    }

    /**
     * @param value ResourceGuard Operation Requests
     */
    @JvmName("txcudsxlefqiploq")
    public suspend fun resourceGuardOperationRequests(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param values ResourceGuard Operation Requests
     */
    @JvmName("rdatbtcgqkgxpgkw")
    public suspend fun resourceGuardOperationRequests(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param value Common settings for the backup management
     */
    @JvmName("itphmfjkkaptfxcs")
    public suspend fun settings(`value`: SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Common settings for the backup management
     */
    @JvmName("hupdguayyekexxca")
    public suspend fun settings(argument: suspend SettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param value List of sub-protection policies which includes schedule and retention
     */
    @JvmName("vwbyfnyanrojimaq")
    public suspend fun subProtectionPolicy(`value`: List<SubProtectionPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subProtectionPolicy = mapped
    }

    /**
     * @param argument List of sub-protection policies which includes schedule and retention
     */
    @JvmName("mxtxpdmvryeqdgni")
    public suspend
    fun subProtectionPolicy(argument: List<suspend SubProtectionPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubProtectionPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subProtectionPolicy = mapped
    }

    /**
     * @param argument List of sub-protection policies which includes schedule and retention
     */
    @JvmName("vawsrbhpmkvixiwm")
    public suspend fun subProtectionPolicy(
        vararg
        argument: suspend SubProtectionPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SubProtectionPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subProtectionPolicy = mapped
    }

    /**
     * @param argument List of sub-protection policies which includes schedule and retention
     */
    @JvmName("dahxatasgdgvoufi")
    public suspend
    fun subProtectionPolicy(argument: suspend SubProtectionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubProtectionPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subProtectionPolicy = mapped
    }

    /**
     * @param values List of sub-protection policies which includes schedule and retention
     */
    @JvmName("cleiixthkwraqmtj")
    public suspend fun subProtectionPolicy(vararg values: SubProtectionPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subProtectionPolicy = mapped
    }

    /**
     * @param value Type of workload for the backup management
     */
    @JvmName("yiroelbfabslgjvk")
    public suspend fun workLoadType(`value`: Either<String, WorkloadType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workLoadType = mapped
    }

    /**
     * @param value Type of workload for the backup management
     */
    @JvmName("jdoirntwpgrmgish")
    public fun workLoadType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workLoadType = mapped
    }

    /**
     * @param value Type of workload for the backup management
     */
    @JvmName("fjobttmoirmytmoi")
    public fun workLoadType(`value`: WorkloadType) {
        val toBeMapped = Either.ofRight<String, WorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workLoadType = mapped
    }

    internal fun build(): AzureVmWorkloadProtectionPolicyArgs = AzureVmWorkloadProtectionPolicyArgs(
        backupManagementType = backupManagementType ?: throw
            PulumiNullFieldException("backupManagementType"),
        makePolicyConsistent = makePolicyConsistent,
        protectedItemsCount = protectedItemsCount,
        resourceGuardOperationRequests = resourceGuardOperationRequests,
        settings = settings,
        subProtectionPolicy = subProtectionPolicy,
        workLoadType = workLoadType,
    )
}
