@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.DailyScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property scheduleRunTimes List of times of day this schedule has to be run.
 */
public data class DailyScheduleArgs(
    public val scheduleRunTimes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.DailyScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.DailyScheduleArgs =
        com.pulumi.azurenative.recoveryservices.inputs.DailyScheduleArgs.builder()
            .scheduleRunTimes(scheduleRunTimes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DailyScheduleArgs].
 */
@PulumiTagMarker
public class DailyScheduleArgsBuilder internal constructor() {
    private var scheduleRunTimes: Output<List<String>>? = null

    /**
     * @param value List of times of day this schedule has to be run.
     */
    @JvmName("vqtlifxmqoywyxom")
    public suspend fun scheduleRunTimes(`value`: Output<List<String>>) {
        this.scheduleRunTimes = value
    }

    @JvmName("gsdjyifwamrgqwbw")
    public suspend fun scheduleRunTimes(vararg values: Output<String>) {
        this.scheduleRunTimes = Output.all(values.asList())
    }

    /**
     * @param values List of times of day this schedule has to be run.
     */
    @JvmName("kgysrixbbgomrgew")
    public suspend fun scheduleRunTimes(values: List<Output<String>>) {
        this.scheduleRunTimes = Output.all(values)
    }

    /**
     * @param value List of times of day this schedule has to be run.
     */
    @JvmName("cdfeuxirneamychg")
    public suspend fun scheduleRunTimes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleRunTimes = mapped
    }

    /**
     * @param values List of times of day this schedule has to be run.
     */
    @JvmName("rpcekcdjwrjtdtfu")
    public suspend fun scheduleRunTimes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleRunTimes = mapped
    }

    internal fun build(): DailyScheduleArgs = DailyScheduleArgs(
        scheduleRunTimes = scheduleRunTimes,
    )
}
