@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GenericProtectionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure VM (Mercury) workload-specific backup policy.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'GenericProtectionPolicy'.
 * @property fabricName Name of this policy's fabric.
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property subProtectionPolicy List of sub-protection policies which includes schedule and retention
 * @property timeZone TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
 */
public data class GenericProtectionPolicyArgs(
    public val backupManagementType: Output<String>,
    public val fabricName: Output<String>? = null,
    public val protectedItemsCount: Output<Int>? = null,
    public val resourceGuardOperationRequests: Output<List<String>>? = null,
    public val subProtectionPolicy: Output<List<SubProtectionPolicyArgs>>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GenericProtectionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.GenericProtectionPolicyArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GenericProtectionPolicyArgs.builder()
            .backupManagementType(backupManagementType.applyValue({ args0 -> args0 }))
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .protectedItemsCount(protectedItemsCount?.applyValue({ args0 -> args0 }))
            .resourceGuardOperationRequests(
                resourceGuardOperationRequests?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .subProtectionPolicy(
                subProtectionPolicy?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GenericProtectionPolicyArgs].
 */
@PulumiTagMarker
public class GenericProtectionPolicyArgsBuilder internal constructor() {
    private var backupManagementType: Output<String>? = null

    private var fabricName: Output<String>? = null

    private var protectedItemsCount: Output<Int>? = null

    private var resourceGuardOperationRequests: Output<List<String>>? = null

    private var subProtectionPolicy: Output<List<SubProtectionPolicyArgs>>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'GenericProtectionPolicy'.
     */
    @JvmName("ahlaxuugdydduxma")
    public suspend fun backupManagementType(`value`: Output<String>) {
        this.backupManagementType = value
    }

    /**
     * @param value Name of this policy's fabric.
     */
    @JvmName("qibcunbcspowoyjm")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Number of items associated with this policy.
     */
    @JvmName("mdkuywtwclxkhkqd")
    public suspend fun protectedItemsCount(`value`: Output<Int>) {
        this.protectedItemsCount = value
    }

    /**
     * @param value ResourceGuard Operation Requests
     */
    @JvmName("eoosyyappcroault")
    public suspend fun resourceGuardOperationRequests(`value`: Output<List<String>>) {
        this.resourceGuardOperationRequests = value
    }

    @JvmName("pmaoctbsaqkacjgh")
    public suspend fun resourceGuardOperationRequests(vararg values: Output<String>) {
        this.resourceGuardOperationRequests = Output.all(values.asList())
    }

    /**
     * @param values ResourceGuard Operation Requests
     */
    @JvmName("tcxrasixtmuvmuuw")
    public suspend fun resourceGuardOperationRequests(values: List<Output<String>>) {
        this.resourceGuardOperationRequests = Output.all(values)
    }

    /**
     * @param value List of sub-protection policies which includes schedule and retention
     */
    @JvmName("uytshirfhiggtyjp")
    public suspend fun subProtectionPolicy(`value`: Output<List<SubProtectionPolicyArgs>>) {
        this.subProtectionPolicy = value
    }

    @JvmName("kjfqeshjndeminth")
    public suspend fun subProtectionPolicy(vararg values: Output<SubProtectionPolicyArgs>) {
        this.subProtectionPolicy = Output.all(values.asList())
    }

    /**
     * @param values List of sub-protection policies which includes schedule and retention
     */
    @JvmName("vwncxjbwxttpgvho")
    public suspend fun subProtectionPolicy(values: List<Output<SubProtectionPolicyArgs>>) {
        this.subProtectionPolicy = Output.all(values)
    }

    /**
     * @param value TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
     */
    @JvmName("migkjvgvtwxbeplk")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'GenericProtectionPolicy'.
     */
    @JvmName("pmikxquueuubkbqw")
    public suspend fun backupManagementType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Name of this policy's fabric.
     */
    @JvmName("tcuknueqvgywuwgw")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Number of items associated with this policy.
     */
    @JvmName("ptvmdjhxghvifepj")
    public suspend fun protectedItemsCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemsCount = mapped
    }

    /**
     * @param value ResourceGuard Operation Requests
     */
    @JvmName("tvdaeebvtgrgnxsj")
    public suspend fun resourceGuardOperationRequests(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param values ResourceGuard Operation Requests
     */
    @JvmName("bommqdsmgwrmclxf")
    public suspend fun resourceGuardOperationRequests(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param value List of sub-protection policies which includes schedule and retention
     */
    @JvmName("yvotbhbjpiqurcch")
    public suspend fun subProtectionPolicy(`value`: List<SubProtectionPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subProtectionPolicy = mapped
    }

    /**
     * @param argument List of sub-protection policies which includes schedule and retention
     */
    @JvmName("llwokpwcsbhhlgrr")
    public suspend
    fun subProtectionPolicy(argument: List<suspend SubProtectionPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubProtectionPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subProtectionPolicy = mapped
    }

    /**
     * @param argument List of sub-protection policies which includes schedule and retention
     */
    @JvmName("qfebuttessawkptq")
    public suspend fun subProtectionPolicy(
        vararg
        argument: suspend SubProtectionPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SubProtectionPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subProtectionPolicy = mapped
    }

    /**
     * @param argument List of sub-protection policies which includes schedule and retention
     */
    @JvmName("edmesknpknkopbhj")
    public suspend
    fun subProtectionPolicy(argument: suspend SubProtectionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubProtectionPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subProtectionPolicy = mapped
    }

    /**
     * @param values List of sub-protection policies which includes schedule and retention
     */
    @JvmName("wahgtieyhnirswby")
    public suspend fun subProtectionPolicy(vararg values: SubProtectionPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subProtectionPolicy = mapped
    }

    /**
     * @param value TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
     */
    @JvmName("ogovmqjhwjdcqtvl")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): GenericProtectionPolicyArgs = GenericProtectionPolicyArgs(
        backupManagementType = backupManagementType ?: throw
            PulumiNullFieldException("backupManagementType"),
        fabricName = fabricName,
        protectedItemsCount = protectedItemsCount,
        resourceGuardOperationRequests = resourceGuardOperationRequests,
        subProtectionPolicy = subProtectionPolicy,
        timeZone = timeZone,
    )
}
