@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetReplicationProtectionContainerMappingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fabricName Fabric name.
 * @property mappingName Protection Container mapping name.
 * @property protectionContainerName Protection container name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class GetReplicationProtectionContainerMappingPlainArgs(
    public val fabricName: String,
    public val mappingName: String,
    public val protectionContainerName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetReplicationProtectionContainerMappingPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationProtectionContainerMappingPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationProtectionContainerMappingPlainArgs.builder()
            .fabricName(fabricName.let({ args0 -> args0 }))
            .mappingName(mappingName.let({ args0 -> args0 }))
            .protectionContainerName(protectionContainerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationProtectionContainerMappingPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationProtectionContainerMappingPlainArgsBuilder internal constructor() {
    private var fabricName: String? = null

    private var mappingName: String? = null

    private var protectionContainerName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Fabric name.
     */
    @JvmName("vnyoeqwycptgbgmb")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value Protection Container mapping name.
     */
    @JvmName("tfoaitjldmgrfgja")
    public suspend fun mappingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mappingName = mapped
    }

    /**
     * @param value Protection container name.
     */
    @JvmName("brvjlraunndayygj")
    public suspend fun protectionContainerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.protectionContainerName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("wkwtrpwdjpkflaxs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("aqovuflghvwpqnvd")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetReplicationProtectionContainerMappingPlainArgs =
        GetReplicationProtectionContainerMappingPlainArgs(
            fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
            mappingName = mappingName ?: throw PulumiNullFieldException("mappingName"),
            protectionContainerName = protectionContainerName ?: throw
                PulumiNullFieldException("protectionContainerName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
