@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.IdentityProviderInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity provider input.
 * @property aadAuthority The base authority for Azure Active Directory authentication.
 * @property applicationId The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 * @property audience The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 * @property objectId The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 * @property tenantId The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 */
public data class IdentityProviderInputArgs(
    public val aadAuthority: Output<String>,
    public val applicationId: Output<String>,
    public val audience: Output<String>,
    public val objectId: Output<String>,
    public val tenantId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.IdentityProviderInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.IdentityProviderInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.IdentityProviderInputArgs.builder()
            .aadAuthority(aadAuthority.applyValue({ args0 -> args0 }))
            .applicationId(applicationId.applyValue({ args0 -> args0 }))
            .audience(audience.applyValue({ args0 -> args0 }))
            .objectId(objectId.applyValue({ args0 -> args0 }))
            .tenantId(tenantId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityProviderInputArgs].
 */
@PulumiTagMarker
public class IdentityProviderInputArgsBuilder internal constructor() {
    private var aadAuthority: Output<String>? = null

    private var applicationId: Output<String>? = null

    private var audience: Output<String>? = null

    private var objectId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value The base authority for Azure Active Directory authentication.
     */
    @JvmName("rltagwjpabpvwrwd")
    public suspend fun aadAuthority(`value`: Output<String>) {
        this.aadAuthority = value
    }

    /**
     * @param value The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("cdpeahkweylfmrpg")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("lphvxpdmbggtiyba")
    public suspend fun audience(`value`: Output<String>) {
        this.audience = value
    }

    /**
     * @param value The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("tewiuhdwuedgjtfj")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("nbgduownkvebbavv")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The base authority for Azure Active Directory authentication.
     */
    @JvmName("uetjkqvwbfywppnn")
    public suspend fun aadAuthority(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aadAuthority = mapped
    }

    /**
     * @param value The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("tyuedryjqeabdlnr")
    public suspend fun applicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("dfpsfydcprsmadnu")
    public suspend fun audience(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audience = mapped
    }

    /**
     * @param value The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("fyspyiuencaufodk")
    public suspend fun objectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("frfmioabekerfvgj")
    public suspend fun tenantId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): IdentityProviderInputArgs = IdentityProviderInputArgs(
        aadAuthority = aadAuthority ?: throw PulumiNullFieldException("aadAuthority"),
        applicationId = applicationId ?: throw PulumiNullFieldException("applicationId"),
        audience = audience ?: throw PulumiNullFieldException("audience"),
        objectId = objectId ?: throw PulumiNullFieldException("objectId"),
        tenantId = tenantId ?: throw PulumiNullFieldException("tenantId"),
    )
}
