@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.ImmutabilitySettingsArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ImmutabilityState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Immutability Settings of vault
 * @property state
 */
public data class ImmutabilitySettingsArgs(
    public val state: Output<Either<String, ImmutabilityState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.ImmutabilitySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.ImmutabilitySettingsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.ImmutabilitySettingsArgs.builder()
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ImmutabilitySettingsArgs].
 */
@PulumiTagMarker
public class ImmutabilitySettingsArgsBuilder internal constructor() {
    private var state: Output<Either<String, ImmutabilityState>>? = null

    /**
     * @param value
     */
    @JvmName("lhxyjqtridvqwdsf")
    public suspend fun state(`value`: Output<Either<String, ImmutabilityState>>) {
        this.state = value
    }

    /**
     * @param value
     */
    @JvmName("msryxmhatbgeujrg")
    public suspend fun state(`value`: Either<String, ImmutabilityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value
     */
    @JvmName("ujmxsxjqvoolojxo")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ImmutabilityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value
     */
    @JvmName("htvcuoflnclrljkw")
    public fun state(`value`: ImmutabilityState) {
        val toBeMapped = Either.ofRight<String, ImmutabilityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): ImmutabilitySettingsArgs = ImmutabilitySettingsArgs(
        state = state,
    )
}
