@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InMageAzureV2DiskInputDetailsArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.DiskAccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Disk input details.
 * @property diskEncryptionSetId The DiskEncryptionSet ARM ID.
 * @property diskId The DiskId.
 * @property diskType The DiskType.
 * @property logStorageAccountId The LogStorageAccountId.
 */
public data class InMageAzureV2DiskInputDetailsArgs(
    public val diskEncryptionSetId: Output<String>? = null,
    public val diskId: Output<String>? = null,
    public val diskType: Output<Either<String, DiskAccountType>>? = null,
    public val logStorageAccountId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InMageAzureV2DiskInputDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.InMageAzureV2DiskInputDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InMageAzureV2DiskInputDetailsArgs.builder()
            .diskEncryptionSetId(diskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .diskId(diskId?.applyValue({ args0 -> args0 }))
            .diskType(
                diskType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .logStorageAccountId(logStorageAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InMageAzureV2DiskInputDetailsArgs].
 */
@PulumiTagMarker
public class InMageAzureV2DiskInputDetailsArgsBuilder internal constructor() {
    private var diskEncryptionSetId: Output<String>? = null

    private var diskId: Output<String>? = null

    private var diskType: Output<Either<String, DiskAccountType>>? = null

    private var logStorageAccountId: Output<String>? = null

    /**
     * @param value The DiskEncryptionSet ARM ID.
     */
    @JvmName("gcmjhknuggyckqba")
    public suspend fun diskEncryptionSetId(`value`: Output<String>) {
        this.diskEncryptionSetId = value
    }

    /**
     * @param value The DiskId.
     */
    @JvmName("knbqfdfwejyislqp")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value The DiskType.
     */
    @JvmName("gwesurhiehdwwmnx")
    public suspend fun diskType(`value`: Output<Either<String, DiskAccountType>>) {
        this.diskType = value
    }

    /**
     * @param value The LogStorageAccountId.
     */
    @JvmName("mmgdgicdcpxibvji")
    public suspend fun logStorageAccountId(`value`: Output<String>) {
        this.logStorageAccountId = value
    }

    /**
     * @param value The DiskEncryptionSet ARM ID.
     */
    @JvmName("istnraqomgsdqsbv")
    public suspend fun diskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetId = mapped
    }

    /**
     * @param value The DiskId.
     */
    @JvmName("donkygllacjmwimb")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value The DiskType.
     */
    @JvmName("apqspfqesfdfeuiw")
    public suspend fun diskType(`value`: Either<String, DiskAccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The DiskType.
     */
    @JvmName("aihnpkoisecujglu")
    public fun diskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The DiskType.
     */
    @JvmName("dfvynfbxfdwlhdcg")
    public fun diskType(`value`: DiskAccountType) {
        val toBeMapped = Either.ofRight<String, DiskAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The LogStorageAccountId.
     */
    @JvmName("kfkihjrbgxcwlmsg")
    public suspend fun logStorageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStorageAccountId = mapped
    }

    internal fun build(): InMageAzureV2DiskInputDetailsArgs = InMageAzureV2DiskInputDetailsArgs(
        diskEncryptionSetId = diskEncryptionSetId,
        diskId = diskId,
        diskType = diskType,
        logStorageAccountId = logStorageAccountId,
    )
}
