@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InMageAzureV2PolicyInputArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.SetMultiVmSyncStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VMWare Azure specific policy Input.
 * @property appConsistentFrequencyInMinutes The app consistent snapshot frequency (in minutes).
 * @property crashConsistentFrequencyInMinutes The crash consistent snapshot frequency (in minutes).
 * @property instanceType The class type.
 * Expected value is 'InMageAzureV2'.
 * @property multiVmSyncStatus A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
 * @property recoveryPointHistory The duration in minutes until which the recovery points need to be stored.
 * @property recoveryPointThresholdInMinutes The recovery point threshold in minutes.
 */
public data class InMageAzureV2PolicyInputArgs(
    public val appConsistentFrequencyInMinutes: Output<Int>? = null,
    public val crashConsistentFrequencyInMinutes: Output<Int>? = null,
    public val instanceType: Output<String>,
    public val multiVmSyncStatus: Output<Either<String, SetMultiVmSyncStatus>>,
    public val recoveryPointHistory: Output<Int>? = null,
    public val recoveryPointThresholdInMinutes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InMageAzureV2PolicyInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.InMageAzureV2PolicyInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InMageAzureV2PolicyInputArgs.builder()
            .appConsistentFrequencyInMinutes(appConsistentFrequencyInMinutes?.applyValue({ args0 -> args0 }))
            .crashConsistentFrequencyInMinutes(
                crashConsistentFrequencyInMinutes?.applyValue({ args0 ->
                    args0
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .multiVmSyncStatus(
                multiVmSyncStatus.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .recoveryPointHistory(recoveryPointHistory?.applyValue({ args0 -> args0 }))
            .recoveryPointThresholdInMinutes(
                recoveryPointThresholdInMinutes?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [InMageAzureV2PolicyInputArgs].
 */
@PulumiTagMarker
public class InMageAzureV2PolicyInputArgsBuilder internal constructor() {
    private var appConsistentFrequencyInMinutes: Output<Int>? = null

    private var crashConsistentFrequencyInMinutes: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var multiVmSyncStatus: Output<Either<String, SetMultiVmSyncStatus>>? = null

    private var recoveryPointHistory: Output<Int>? = null

    private var recoveryPointThresholdInMinutes: Output<Int>? = null

    /**
     * @param value The app consistent snapshot frequency (in minutes).
     */
    @JvmName("drtsnrunrrnclvvv")
    public suspend fun appConsistentFrequencyInMinutes(`value`: Output<Int>) {
        this.appConsistentFrequencyInMinutes = value
    }

    /**
     * @param value The crash consistent snapshot frequency (in minutes).
     */
    @JvmName("fjeqcxcgreaabghd")
    public suspend fun crashConsistentFrequencyInMinutes(`value`: Output<Int>) {
        this.crashConsistentFrequencyInMinutes = value
    }

    /**
     * @param value The class type.
     * Expected value is 'InMageAzureV2'.
     */
    @JvmName("ptjnbckfnbpxlnru")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
     */
    @JvmName("pplxgwsyyrmdhjxt")
    public suspend fun multiVmSyncStatus(`value`: Output<Either<String, SetMultiVmSyncStatus>>) {
        this.multiVmSyncStatus = value
    }

    /**
     * @param value The duration in minutes until which the recovery points need to be stored.
     */
    @JvmName("hxxtbuwsuoxdxdlv")
    public suspend fun recoveryPointHistory(`value`: Output<Int>) {
        this.recoveryPointHistory = value
    }

    /**
     * @param value The recovery point threshold in minutes.
     */
    @JvmName("dibpjipbycqjmkuq")
    public suspend fun recoveryPointThresholdInMinutes(`value`: Output<Int>) {
        this.recoveryPointThresholdInMinutes = value
    }

    /**
     * @param value The app consistent snapshot frequency (in minutes).
     */
    @JvmName("wjhdronqhaocyqib")
    public suspend fun appConsistentFrequencyInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appConsistentFrequencyInMinutes = mapped
    }

    /**
     * @param value The crash consistent snapshot frequency (in minutes).
     */
    @JvmName("lqwidyoniqimeuvf")
    public suspend fun crashConsistentFrequencyInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crashConsistentFrequencyInMinutes = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'InMageAzureV2'.
     */
    @JvmName("uipjogsujdlcqlyq")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
     */
    @JvmName("cygfvqvefmjwvhsg")
    public suspend fun multiVmSyncStatus(`value`: Either<String, SetMultiVmSyncStatus>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiVmSyncStatus = mapped
    }

    /**
     * @param value A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
     */
    @JvmName("qwviddylsnqmimdu")
    public fun multiVmSyncStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SetMultiVmSyncStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiVmSyncStatus = mapped
    }

    /**
     * @param value A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
     */
    @JvmName("memlklhnchvoodvs")
    public fun multiVmSyncStatus(`value`: SetMultiVmSyncStatus) {
        val toBeMapped = Either.ofRight<String, SetMultiVmSyncStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiVmSyncStatus = mapped
    }

    /**
     * @param value The duration in minutes until which the recovery points need to be stored.
     */
    @JvmName("nuwvcrtwnsdldkrq")
    public suspend fun recoveryPointHistory(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPointHistory = mapped
    }

    /**
     * @param value The recovery point threshold in minutes.
     */
    @JvmName("ofjngpibgmffojiu")
    public suspend fun recoveryPointThresholdInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPointThresholdInMinutes = mapped
    }

    internal fun build(): InMageAzureV2PolicyInputArgs = InMageAzureV2PolicyInputArgs(
        appConsistentFrequencyInMinutes = appConsistentFrequencyInMinutes,
        crashConsistentFrequencyInMinutes = crashConsistentFrequencyInMinutes,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        multiVmSyncStatus = multiVmSyncStatus ?: throw PulumiNullFieldException("multiVmSyncStatus"),
        recoveryPointHistory = recoveryPointHistory,
        recoveryPointThresholdInMinutes = recoveryPointThresholdInMinutes,
    )
}
