@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InMageVolumeExclusionOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Guest disk signature based disk exclusion option when doing enable protection of virtual machine in InMage provider.
 * @property onlyExcludeIfSingleVolume The value indicating whether to exclude multi volume disk or not. If a disk has multiple volumes and one of the volume has label matching with VolumeLabel this disk will be excluded from replication if OnlyExcludeIfSingleVolume is false.
 * @property volumeLabel The volume label. The disk having any volume with this label will be excluded from replication.
 */
public data class InMageVolumeExclusionOptionsArgs(
    public val onlyExcludeIfSingleVolume: Output<String>? = null,
    public val volumeLabel: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InMageVolumeExclusionOptionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.InMageVolumeExclusionOptionsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InMageVolumeExclusionOptionsArgs.builder()
            .onlyExcludeIfSingleVolume(onlyExcludeIfSingleVolume?.applyValue({ args0 -> args0 }))
            .volumeLabel(volumeLabel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InMageVolumeExclusionOptionsArgs].
 */
@PulumiTagMarker
public class InMageVolumeExclusionOptionsArgsBuilder internal constructor() {
    private var onlyExcludeIfSingleVolume: Output<String>? = null

    private var volumeLabel: Output<String>? = null

    /**
     * @param value The value indicating whether to exclude multi volume disk or not. If a disk has multiple volumes and one of the volume has label matching with VolumeLabel this disk will be excluded from replication if OnlyExcludeIfSingleVolume is false.
     */
    @JvmName("avgfxopqameubbtg")
    public suspend fun onlyExcludeIfSingleVolume(`value`: Output<String>) {
        this.onlyExcludeIfSingleVolume = value
    }

    /**
     * @param value The volume label. The disk having any volume with this label will be excluded from replication.
     */
    @JvmName("imdyksxxxgcyraok")
    public suspend fun volumeLabel(`value`: Output<String>) {
        this.volumeLabel = value
    }

    /**
     * @param value The value indicating whether to exclude multi volume disk or not. If a disk has multiple volumes and one of the volume has label matching with VolumeLabel this disk will be excluded from replication if OnlyExcludeIfSingleVolume is false.
     */
    @JvmName("vsjatwnrgiqvmijb")
    public suspend fun onlyExcludeIfSingleVolume(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onlyExcludeIfSingleVolume = mapped
    }

    /**
     * @param value The volume label. The disk having any volume with this label will be excluded from replication.
     */
    @JvmName("lhluxidlnoyxfybv")
    public suspend fun volumeLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeLabel = mapped
    }

    internal fun build(): InMageVolumeExclusionOptionsArgs = InMageVolumeExclusionOptionsArgs(
        onlyExcludeIfSingleVolume = onlyExcludeIfSingleVolume,
        volumeLabel = volumeLabel,
    )
}
