@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.recoveryservices.kotlin.enums.VaultSubResourceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Private Endpoint Connection Response Properties
 * @property groupIds Group Ids for the Private Endpoint
 * @property privateEndpoint Gets or sets private endpoint associated with the private endpoint connection
 * @property privateLinkServiceConnectionState Gets or sets private link service connection state
 * @property provisioningState Gets or sets provisioning state of the private endpoint connection
 */
public data class PrivateEndpointConnectionArgs(
    public val groupIds: Output<List<Either<String, VaultSubResourceType>>>? = null,
    public val privateEndpoint: Output<PrivateEndpointArgs>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.PrivateEndpointConnectionArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.recoveryservices.inputs.PrivateEndpointConnectionArgs.builder()
            .groupIds(
                groupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var groupIds: Output<List<Either<String, VaultSubResourceType>>>? = null

    private var privateEndpoint: Output<PrivateEndpointArgs>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    /**
     * @param value Group Ids for the Private Endpoint
     */
    @JvmName("uqiidoynguhkrnlg")
    public suspend fun groupIds(`value`: Output<List<Either<String, VaultSubResourceType>>>) {
        this.groupIds = value
    }

    @JvmName("kpeahfwyxxeosufr")
    public suspend fun groupIds(vararg values: Output<Either<String, VaultSubResourceType>>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values Group Ids for the Private Endpoint
     */
    @JvmName("osxdgtfwqlljlgwn")
    public suspend fun groupIds(values: List<Output<Either<String, VaultSubResourceType>>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value Gets or sets private endpoint associated with the private endpoint connection
     */
    @JvmName("exkqtblmksrwnarg")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value Gets or sets private link service connection state
     */
    @JvmName("kugsxigbtnwpsjfa")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Gets or sets provisioning state of the private endpoint connection
     */
    @JvmName("lncesvorbqamojeq")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Group Ids for the Private Endpoint
     */
    @JvmName("dltqtrsxuhhclitl")
    public suspend fun groupIds(`value`: List<Either<String, VaultSubResourceType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values Group Ids for the Private Endpoint
     */
    @JvmName("vrjiateneyckjjfi")
    public suspend fun groupIds(vararg values: Either<String, VaultSubResourceType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value Gets or sets private endpoint associated with the private endpoint connection
     */
    @JvmName("cbsxavpvssbbtydl")
    public suspend fun privateEndpoint(`value`: PrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument Gets or sets private endpoint associated with the private endpoint connection
     */
    @JvmName("qgyxwfqeapvwdtkf")
    public suspend fun privateEndpoint(argument: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value Gets or sets private link service connection state
     */
    @JvmName("ignqanwhykhuxhon")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Gets or sets private link service connection state
     */
    @JvmName("xduxdpsrnipkvtgi")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Gets or sets provisioning state of the private endpoint connection
     */
    @JvmName("luxshvwrsmayeema")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Gets or sets provisioning state of the private endpoint connection
     */
    @JvmName("ouvkgehwavypdwua")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Gets or sets provisioning state of the private endpoint connection
     */
    @JvmName("aexgxdcuterdstly")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        groupIds = groupIds,
        privateEndpoint = privateEndpoint,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        provisioningState = provisioningState,
    )
}
