@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanGroupArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.RecoveryPlanGroupType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Recovery plan group details.
 * @property endGroupActions The end group actions.
 * @property groupType The group type.
 * @property replicationProtectedItems The list of protected items.
 * @property startGroupActions The start group actions.
 */
public data class RecoveryPlanGroupArgs(
    public val endGroupActions: Output<List<RecoveryPlanActionArgs>>? = null,
    public val groupType: Output<Either<String, RecoveryPlanGroupType>>,
    public val replicationProtectedItems: Output<List<RecoveryPlanProtectedItemArgs>>? = null,
    public val startGroupActions: Output<List<RecoveryPlanActionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanGroupArgs =
        com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanGroupArgs.builder()
            .endGroupActions(
                endGroupActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .groupType(
                groupType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .replicationProtectedItems(
                replicationProtectedItems?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .startGroupActions(
                startGroupActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RecoveryPlanGroupArgs].
 */
@PulumiTagMarker
public class RecoveryPlanGroupArgsBuilder internal constructor() {
    private var endGroupActions: Output<List<RecoveryPlanActionArgs>>? = null

    private var groupType: Output<Either<String, RecoveryPlanGroupType>>? = null

    private var replicationProtectedItems: Output<List<RecoveryPlanProtectedItemArgs>>? = null

    private var startGroupActions: Output<List<RecoveryPlanActionArgs>>? = null

    /**
     * @param value The end group actions.
     */
    @JvmName("htucqovxrkpcoucn")
    public suspend fun endGroupActions(`value`: Output<List<RecoveryPlanActionArgs>>) {
        this.endGroupActions = value
    }

    @JvmName("dmnldngwkalmeuao")
    public suspend fun endGroupActions(vararg values: Output<RecoveryPlanActionArgs>) {
        this.endGroupActions = Output.all(values.asList())
    }

    /**
     * @param values The end group actions.
     */
    @JvmName("egsbholdthnljstr")
    public suspend fun endGroupActions(values: List<Output<RecoveryPlanActionArgs>>) {
        this.endGroupActions = Output.all(values)
    }

    /**
     * @param value The group type.
     */
    @JvmName("shwolqrtlcdmomxg")
    public suspend fun groupType(`value`: Output<Either<String, RecoveryPlanGroupType>>) {
        this.groupType = value
    }

    /**
     * @param value The list of protected items.
     */
    @JvmName("dhbcdjkuvdahepra")
    public suspend
    fun replicationProtectedItems(`value`: Output<List<RecoveryPlanProtectedItemArgs>>) {
        this.replicationProtectedItems = value
    }

    @JvmName("ttyxxmbffjclhvef")
    public suspend fun replicationProtectedItems(
        vararg
        values: Output<RecoveryPlanProtectedItemArgs>,
    ) {
        this.replicationProtectedItems = Output.all(values.asList())
    }

    /**
     * @param values The list of protected items.
     */
    @JvmName("rtlauprpepdnaphx")
    public suspend
    fun replicationProtectedItems(values: List<Output<RecoveryPlanProtectedItemArgs>>) {
        this.replicationProtectedItems = Output.all(values)
    }

    /**
     * @param value The start group actions.
     */
    @JvmName("mbflxgkhjfccbnte")
    public suspend fun startGroupActions(`value`: Output<List<RecoveryPlanActionArgs>>) {
        this.startGroupActions = value
    }

    @JvmName("vkfaqdhienwielaa")
    public suspend fun startGroupActions(vararg values: Output<RecoveryPlanActionArgs>) {
        this.startGroupActions = Output.all(values.asList())
    }

    /**
     * @param values The start group actions.
     */
    @JvmName("eeppaidlwopcnmmp")
    public suspend fun startGroupActions(values: List<Output<RecoveryPlanActionArgs>>) {
        this.startGroupActions = Output.all(values)
    }

    /**
     * @param value The end group actions.
     */
    @JvmName("xlclbutmyucmdvsn")
    public suspend fun endGroupActions(`value`: List<RecoveryPlanActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endGroupActions = mapped
    }

    /**
     * @param argument The end group actions.
     */
    @JvmName("twhjtdmpgmpiuida")
    public suspend
    fun endGroupActions(argument: List<suspend RecoveryPlanActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecoveryPlanActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endGroupActions = mapped
    }

    /**
     * @param argument The end group actions.
     */
    @JvmName("bugencrrkfqvhijh")
    public suspend fun endGroupActions(
        vararg
        argument: suspend RecoveryPlanActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RecoveryPlanActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endGroupActions = mapped
    }

    /**
     * @param argument The end group actions.
     */
    @JvmName("omjnvmiyugkhkxva")
    public suspend fun endGroupActions(argument: suspend RecoveryPlanActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RecoveryPlanActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endGroupActions = mapped
    }

    /**
     * @param values The end group actions.
     */
    @JvmName("ihigqrseglsyqbyo")
    public suspend fun endGroupActions(vararg values: RecoveryPlanActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endGroupActions = mapped
    }

    /**
     * @param value The group type.
     */
    @JvmName("tguyelnkugiykupk")
    public suspend fun groupType(`value`: Either<String, RecoveryPlanGroupType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value The group type.
     */
    @JvmName("rjjmmpfmqhagslsc")
    public fun groupType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecoveryPlanGroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value The group type.
     */
    @JvmName("ihacxmbirlcbvpdc")
    public fun groupType(`value`: RecoveryPlanGroupType) {
        val toBeMapped = Either.ofRight<String, RecoveryPlanGroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value The list of protected items.
     */
    @JvmName("iarqxjsnsggndqeg")
    public suspend fun replicationProtectedItems(`value`: List<RecoveryPlanProtectedItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationProtectedItems = mapped
    }

    /**
     * @param argument The list of protected items.
     */
    @JvmName("dgrtrqumubugahxr")
    public suspend
    fun replicationProtectedItems(argument: List<suspend RecoveryPlanProtectedItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecoveryPlanProtectedItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.replicationProtectedItems = mapped
    }

    /**
     * @param argument The list of protected items.
     */
    @JvmName("jyqbqkgunagkjrrc")
    public suspend fun replicationProtectedItems(
        vararg
        argument: suspend RecoveryPlanProtectedItemArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RecoveryPlanProtectedItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.replicationProtectedItems = mapped
    }

    /**
     * @param argument The list of protected items.
     */
    @JvmName("dkfifwpgorrgdgoc")
    public suspend
    fun replicationProtectedItems(argument: suspend RecoveryPlanProtectedItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecoveryPlanProtectedItemArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.replicationProtectedItems = mapped
    }

    /**
     * @param values The list of protected items.
     */
    @JvmName("kwpdfkqmwwkpkqfo")
    public suspend fun replicationProtectedItems(vararg values: RecoveryPlanProtectedItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationProtectedItems = mapped
    }

    /**
     * @param value The start group actions.
     */
    @JvmName("mlybmpnowoyrxnkm")
    public suspend fun startGroupActions(`value`: List<RecoveryPlanActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startGroupActions = mapped
    }

    /**
     * @param argument The start group actions.
     */
    @JvmName("xlmwqtjlpdmthamm")
    public suspend
    fun startGroupActions(argument: List<suspend RecoveryPlanActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecoveryPlanActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.startGroupActions = mapped
    }

    /**
     * @param argument The start group actions.
     */
    @JvmName("mkclmmyylmruovxi")
    public suspend fun startGroupActions(
        vararg
        argument: suspend RecoveryPlanActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RecoveryPlanActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.startGroupActions = mapped
    }

    /**
     * @param argument The start group actions.
     */
    @JvmName("msvspojugrbxalhe")
    public suspend fun startGroupActions(argument: suspend RecoveryPlanActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RecoveryPlanActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.startGroupActions = mapped
    }

    /**
     * @param values The start group actions.
     */
    @JvmName("rrjefmtdorcoqypm")
    public suspend fun startGroupActions(vararg values: RecoveryPlanActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startGroupActions = mapped
    }

    internal fun build(): RecoveryPlanGroupArgs = RecoveryPlanGroupArgs(
        endGroupActions = endGroupActions,
        groupType = groupType ?: throw PulumiNullFieldException("groupType"),
        replicationProtectedItems = replicationProtectedItems,
        startGroupActions = startGroupActions,
    )
}
