@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.SimpleSchedulePolicyV2Args.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ScheduleRunType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The V2 policy schedule for IaaS that supports hourly backups.
 * @property dailySchedule Daily schedule of this policy
 * @property hourlySchedule hourly schedule of this policy
 * @property schedulePolicyType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'SimpleSchedulePolicyV2'.
 * @property scheduleRunFrequency Frequency of the schedule operation of this policy.
 * @property weeklySchedule Weekly schedule of this policy
 */
public data class SimpleSchedulePolicyV2Args(
    public val dailySchedule: Output<DailyScheduleArgs>? = null,
    public val hourlySchedule: Output<HourlyScheduleArgs>? = null,
    public val schedulePolicyType: Output<String>,
    public val scheduleRunFrequency: Output<Either<String, ScheduleRunType>>? = null,
    public val weeklySchedule: Output<WeeklyScheduleArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.SimpleSchedulePolicyV2Args> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.SimpleSchedulePolicyV2Args =
        com.pulumi.azurenative.recoveryservices.inputs.SimpleSchedulePolicyV2Args.builder()
            .dailySchedule(dailySchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hourlySchedule(hourlySchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schedulePolicyType(schedulePolicyType.applyValue({ args0 -> args0 }))
            .scheduleRunFrequency(
                scheduleRunFrequency?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .weeklySchedule(
                weeklySchedule?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SimpleSchedulePolicyV2Args].
 */
@PulumiTagMarker
public class SimpleSchedulePolicyV2ArgsBuilder internal constructor() {
    private var dailySchedule: Output<DailyScheduleArgs>? = null

    private var hourlySchedule: Output<HourlyScheduleArgs>? = null

    private var schedulePolicyType: Output<String>? = null

    private var scheduleRunFrequency: Output<Either<String, ScheduleRunType>>? = null

    private var weeklySchedule: Output<WeeklyScheduleArgs>? = null

    /**
     * @param value Daily schedule of this policy
     */
    @JvmName("ykkcybyaxapsipwv")
    public suspend fun dailySchedule(`value`: Output<DailyScheduleArgs>) {
        this.dailySchedule = value
    }

    /**
     * @param value hourly schedule of this policy
     */
    @JvmName("uhkjnghcjubjplvv")
    public suspend fun hourlySchedule(`value`: Output<HourlyScheduleArgs>) {
        this.hourlySchedule = value
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'SimpleSchedulePolicyV2'.
     */
    @JvmName("aimrkxdpphtwjtrf")
    public suspend fun schedulePolicyType(`value`: Output<String>) {
        this.schedulePolicyType = value
    }

    /**
     * @param value Frequency of the schedule operation of this policy.
     */
    @JvmName("mvnoxjnqdetuuslb")
    public suspend fun scheduleRunFrequency(`value`: Output<Either<String, ScheduleRunType>>) {
        this.scheduleRunFrequency = value
    }

    /**
     * @param value Weekly schedule of this policy
     */
    @JvmName("ngxiaomskprmeule")
    public suspend fun weeklySchedule(`value`: Output<WeeklyScheduleArgs>) {
        this.weeklySchedule = value
    }

    /**
     * @param value Daily schedule of this policy
     */
    @JvmName("kihruxfhbdlvlcto")
    public suspend fun dailySchedule(`value`: DailyScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailySchedule = mapped
    }

    /**
     * @param argument Daily schedule of this policy
     */
    @JvmName("eogdwnhbujbjmcxp")
    public suspend fun dailySchedule(argument: suspend DailyScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = DailyScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dailySchedule = mapped
    }

    /**
     * @param value hourly schedule of this policy
     */
    @JvmName("tsdqjhldacpjclys")
    public suspend fun hourlySchedule(`value`: HourlyScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hourlySchedule = mapped
    }

    /**
     * @param argument hourly schedule of this policy
     */
    @JvmName("ddnxcbnbvbooaavs")
    public suspend fun hourlySchedule(argument: suspend HourlyScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = HourlyScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hourlySchedule = mapped
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'SimpleSchedulePolicyV2'.
     */
    @JvmName("yvwubxllfcawjytk")
    public suspend fun schedulePolicyType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedulePolicyType = mapped
    }

    /**
     * @param value Frequency of the schedule operation of this policy.
     */
    @JvmName("hwsptrghqbrnpchy")
    public suspend fun scheduleRunFrequency(`value`: Either<String, ScheduleRunType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleRunFrequency = mapped
    }

    /**
     * @param value Frequency of the schedule operation of this policy.
     */
    @JvmName("orhgmuyduvtcomft")
    public fun scheduleRunFrequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduleRunType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleRunFrequency = mapped
    }

    /**
     * @param value Frequency of the schedule operation of this policy.
     */
    @JvmName("wuubvkawqgdbntcj")
    public fun scheduleRunFrequency(`value`: ScheduleRunType) {
        val toBeMapped = Either.ofRight<String, ScheduleRunType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleRunFrequency = mapped
    }

    /**
     * @param value Weekly schedule of this policy
     */
    @JvmName("fnihrxpixmnlxanj")
    public suspend fun weeklySchedule(`value`: WeeklyScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklySchedule = mapped
    }

    /**
     * @param argument Weekly schedule of this policy
     */
    @JvmName("oayllymhysxlixfa")
    public suspend fun weeklySchedule(argument: suspend WeeklyScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = WeeklyScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.weeklySchedule = mapped
    }

    internal fun build(): SimpleSchedulePolicyV2Args = SimpleSchedulePolicyV2Args(
        dailySchedule = dailySchedule,
        hourlySchedule = hourlySchedule,
        schedulePolicyType = schedulePolicyType ?: throw PulumiNullFieldException("schedulePolicyType"),
        scheduleRunFrequency = scheduleRunFrequency,
        weeklySchedule = weeklySchedule,
    )
}
