@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtEnableMigrationInputArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.LicenseType
import com.pulumi.azurenative.recoveryservices.kotlin.enums.SqlServerLicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * VMwareCbt specific enable migration input.
 * @property confidentialVmKeyVaultId The confidential VM key vault Id for ADE installation.
 * @property dataMoverRunAsAccountId The data mover run as account Id.
 * @property disksToInclude The disks to include list.
 * @property instanceType The class type.
 * Expected value is 'VMwareCbt'.
 * @property licenseType License type.
 * @property performAutoResync A value indicating whether auto resync is to be done.
 * @property performSqlBulkRegistration A value indicating whether bulk SQL RP registration to be done.
 * @property seedDiskTags The tags for the seed disks.
 * @property snapshotRunAsAccountId The snapshot run as account Id.
 * @property sqlServerLicenseType The SQL Server license type.
 * @property targetAvailabilitySetId The target availability set ARM Id.
 * @property targetAvailabilityZone The target availability zone.
 * @property targetBootDiagnosticsStorageAccountId The target boot diagnostics storage account ARM Id.
 * @property targetDiskTags The tags for the target disks.
 * @property targetNetworkId The target network ARM Id.
 * @property targetNicTags The tags for the target NICs.
 * @property targetProximityPlacementGroupId The target proximity placement group ARM Id.
 * @property targetResourceGroupId The target resource group ARM Id.
 * @property targetSubnetName The target subnet name.
 * @property targetVmName The target VM name.
 * @property targetVmSecurityProfile The target VM security profile.
 * @property targetVmSize The target VM size.
 * @property targetVmTags The target VM tags.
 * @property testNetworkId The selected test network ARM Id.
 * @property testSubnetName The selected test subnet name.
 * @property vmwareMachineId The ARM Id of the VM discovered in VMware.
 */
public data class VMwareCbtEnableMigrationInputArgs(
    public val confidentialVmKeyVaultId: Output<String>? = null,
    public val dataMoverRunAsAccountId: Output<String>,
    public val disksToInclude: Output<List<VMwareCbtDiskInputArgs>>,
    public val instanceType: Output<String>,
    public val licenseType: Output<Either<String, LicenseType>>? = null,
    public val performAutoResync: Output<String>? = null,
    public val performSqlBulkRegistration: Output<String>? = null,
    public val seedDiskTags: Output<Map<String, String>>? = null,
    public val snapshotRunAsAccountId: Output<String>,
    public val sqlServerLicenseType: Output<Either<String, SqlServerLicenseType>>? = null,
    public val targetAvailabilitySetId: Output<String>? = null,
    public val targetAvailabilityZone: Output<String>? = null,
    public val targetBootDiagnosticsStorageAccountId: Output<String>? = null,
    public val targetDiskTags: Output<Map<String, String>>? = null,
    public val targetNetworkId: Output<String>,
    public val targetNicTags: Output<Map<String, String>>? = null,
    public val targetProximityPlacementGroupId: Output<String>? = null,
    public val targetResourceGroupId: Output<String>,
    public val targetSubnetName: Output<String>? = null,
    public val targetVmName: Output<String>? = null,
    public val targetVmSecurityProfile: Output<VMwareCbtSecurityProfilePropertiesArgs>? = null,
    public val targetVmSize: Output<String>? = null,
    public val targetVmTags: Output<Map<String, String>>? = null,
    public val testNetworkId: Output<String>? = null,
    public val testSubnetName: Output<String>? = null,
    public val vmwareMachineId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtEnableMigrationInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtEnableMigrationInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtEnableMigrationInputArgs.builder()
            .confidentialVmKeyVaultId(confidentialVmKeyVaultId?.applyValue({ args0 -> args0 }))
            .dataMoverRunAsAccountId(dataMoverRunAsAccountId.applyValue({ args0 -> args0 }))
            .disksToInclude(
                disksToInclude.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .performAutoResync(performAutoResync?.applyValue({ args0 -> args0 }))
            .performSqlBulkRegistration(performSqlBulkRegistration?.applyValue({ args0 -> args0 }))
            .seedDiskTags(
                seedDiskTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .snapshotRunAsAccountId(snapshotRunAsAccountId.applyValue({ args0 -> args0 }))
            .sqlServerLicenseType(
                sqlServerLicenseType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .targetAvailabilitySetId(targetAvailabilitySetId?.applyValue({ args0 -> args0 }))
            .targetAvailabilityZone(targetAvailabilityZone?.applyValue({ args0 -> args0 }))
            .targetBootDiagnosticsStorageAccountId(
                targetBootDiagnosticsStorageAccountId?.applyValue({ args0 ->
                    args0
                }),
            )
            .targetDiskTags(
                targetDiskTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .targetNetworkId(targetNetworkId.applyValue({ args0 -> args0 }))
            .targetNicTags(
                targetNicTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .targetProximityPlacementGroupId(targetProximityPlacementGroupId?.applyValue({ args0 -> args0 }))
            .targetResourceGroupId(targetResourceGroupId.applyValue({ args0 -> args0 }))
            .targetSubnetName(targetSubnetName?.applyValue({ args0 -> args0 }))
            .targetVmName(targetVmName?.applyValue({ args0 -> args0 }))
            .targetVmSecurityProfile(
                targetVmSecurityProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetVmSize(targetVmSize?.applyValue({ args0 -> args0 }))
            .targetVmTags(
                targetVmTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .testNetworkId(testNetworkId?.applyValue({ args0 -> args0 }))
            .testSubnetName(testSubnetName?.applyValue({ args0 -> args0 }))
            .vmwareMachineId(vmwareMachineId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VMwareCbtEnableMigrationInputArgs].
 */
@PulumiTagMarker
public class VMwareCbtEnableMigrationInputArgsBuilder internal constructor() {
    private var confidentialVmKeyVaultId: Output<String>? = null

    private var dataMoverRunAsAccountId: Output<String>? = null

    private var disksToInclude: Output<List<VMwareCbtDiskInputArgs>>? = null

    private var instanceType: Output<String>? = null

    private var licenseType: Output<Either<String, LicenseType>>? = null

    private var performAutoResync: Output<String>? = null

    private var performSqlBulkRegistration: Output<String>? = null

    private var seedDiskTags: Output<Map<String, String>>? = null

    private var snapshotRunAsAccountId: Output<String>? = null

    private var sqlServerLicenseType: Output<Either<String, SqlServerLicenseType>>? = null

    private var targetAvailabilitySetId: Output<String>? = null

    private var targetAvailabilityZone: Output<String>? = null

    private var targetBootDiagnosticsStorageAccountId: Output<String>? = null

    private var targetDiskTags: Output<Map<String, String>>? = null

    private var targetNetworkId: Output<String>? = null

    private var targetNicTags: Output<Map<String, String>>? = null

    private var targetProximityPlacementGroupId: Output<String>? = null

    private var targetResourceGroupId: Output<String>? = null

    private var targetSubnetName: Output<String>? = null

    private var targetVmName: Output<String>? = null

    private var targetVmSecurityProfile: Output<VMwareCbtSecurityProfilePropertiesArgs>? = null

    private var targetVmSize: Output<String>? = null

    private var targetVmTags: Output<Map<String, String>>? = null

    private var testNetworkId: Output<String>? = null

    private var testSubnetName: Output<String>? = null

    private var vmwareMachineId: Output<String>? = null

    /**
     * @param value The confidential VM key vault Id for ADE installation.
     */
    @JvmName("gcabcqsnfqtmxqfa")
    public suspend fun confidentialVmKeyVaultId(`value`: Output<String>) {
        this.confidentialVmKeyVaultId = value
    }

    /**
     * @param value The data mover run as account Id.
     */
    @JvmName("jwtbqmfchisxgfqk")
    public suspend fun dataMoverRunAsAccountId(`value`: Output<String>) {
        this.dataMoverRunAsAccountId = value
    }

    /**
     * @param value The disks to include list.
     */
    @JvmName("pklfkehktulsutbq")
    public suspend fun disksToInclude(`value`: Output<List<VMwareCbtDiskInputArgs>>) {
        this.disksToInclude = value
    }

    @JvmName("uysniuuijbvgwaes")
    public suspend fun disksToInclude(vararg values: Output<VMwareCbtDiskInputArgs>) {
        this.disksToInclude = Output.all(values.asList())
    }

    /**
     * @param values The disks to include list.
     */
    @JvmName("ajebidwkbqwsnbkt")
    public suspend fun disksToInclude(values: List<Output<VMwareCbtDiskInputArgs>>) {
        this.disksToInclude = Output.all(values)
    }

    /**
     * @param value The class type.
     * Expected value is 'VMwareCbt'.
     */
    @JvmName("actujrcmjspwucyd")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value License type.
     */
    @JvmName("okjoofmurqlttkjn")
    public suspend fun licenseType(`value`: Output<Either<String, LicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value A value indicating whether auto resync is to be done.
     */
    @JvmName("gvxsenjoelcshaej")
    public suspend fun performAutoResync(`value`: Output<String>) {
        this.performAutoResync = value
    }

    /**
     * @param value A value indicating whether bulk SQL RP registration to be done.
     */
    @JvmName("rnfneikcdktmqiqf")
    public suspend fun performSqlBulkRegistration(`value`: Output<String>) {
        this.performSqlBulkRegistration = value
    }

    /**
     * @param value The tags for the seed disks.
     */
    @JvmName("iwrrsarqqewqcprg")
    public suspend fun seedDiskTags(`value`: Output<Map<String, String>>) {
        this.seedDiskTags = value
    }

    /**
     * @param value The snapshot run as account Id.
     */
    @JvmName("mfphdmdjhkcsjwpu")
    public suspend fun snapshotRunAsAccountId(`value`: Output<String>) {
        this.snapshotRunAsAccountId = value
    }

    /**
     * @param value The SQL Server license type.
     */
    @JvmName("tdydwbogbjefodko")
    public suspend fun sqlServerLicenseType(`value`: Output<Either<String, SqlServerLicenseType>>) {
        this.sqlServerLicenseType = value
    }

    /**
     * @param value The target availability set ARM Id.
     */
    @JvmName("ulrbddeoqtfbporu")
    public suspend fun targetAvailabilitySetId(`value`: Output<String>) {
        this.targetAvailabilitySetId = value
    }

    /**
     * @param value The target availability zone.
     */
    @JvmName("eujikeifugspyspi")
    public suspend fun targetAvailabilityZone(`value`: Output<String>) {
        this.targetAvailabilityZone = value
    }

    /**
     * @param value The target boot diagnostics storage account ARM Id.
     */
    @JvmName("wcumjsbddwbhtgix")
    public suspend fun targetBootDiagnosticsStorageAccountId(`value`: Output<String>) {
        this.targetBootDiagnosticsStorageAccountId = value
    }

    /**
     * @param value The tags for the target disks.
     */
    @JvmName("elwnmlpuxygshhau")
    public suspend fun targetDiskTags(`value`: Output<Map<String, String>>) {
        this.targetDiskTags = value
    }

    /**
     * @param value The target network ARM Id.
     */
    @JvmName("eiebeuixhglwpdfa")
    public suspend fun targetNetworkId(`value`: Output<String>) {
        this.targetNetworkId = value
    }

    /**
     * @param value The tags for the target NICs.
     */
    @JvmName("yiseanxwkonmougd")
    public suspend fun targetNicTags(`value`: Output<Map<String, String>>) {
        this.targetNicTags = value
    }

    /**
     * @param value The target proximity placement group ARM Id.
     */
    @JvmName("rcxovrfgdehqclal")
    public suspend fun targetProximityPlacementGroupId(`value`: Output<String>) {
        this.targetProximityPlacementGroupId = value
    }

    /**
     * @param value The target resource group ARM Id.
     */
    @JvmName("wugskuxiwycxapwp")
    public suspend fun targetResourceGroupId(`value`: Output<String>) {
        this.targetResourceGroupId = value
    }

    /**
     * @param value The target subnet name.
     */
    @JvmName("xydgofpjpupoqrpm")
    public suspend fun targetSubnetName(`value`: Output<String>) {
        this.targetSubnetName = value
    }

    /**
     * @param value The target VM name.
     */
    @JvmName("djrjbmyqupahtauy")
    public suspend fun targetVmName(`value`: Output<String>) {
        this.targetVmName = value
    }

    /**
     * @param value The target VM security profile.
     */
    @JvmName("kydpkbwqmltbkiuk")
    public suspend
    fun targetVmSecurityProfile(`value`: Output<VMwareCbtSecurityProfilePropertiesArgs>) {
        this.targetVmSecurityProfile = value
    }

    /**
     * @param value The target VM size.
     */
    @JvmName("cyeorjlbekjjqvmv")
    public suspend fun targetVmSize(`value`: Output<String>) {
        this.targetVmSize = value
    }

    /**
     * @param value The target VM tags.
     */
    @JvmName("hxkkrwjyskvoltdr")
    public suspend fun targetVmTags(`value`: Output<Map<String, String>>) {
        this.targetVmTags = value
    }

    /**
     * @param value The selected test network ARM Id.
     */
    @JvmName("xggbvuwwxsgkguew")
    public suspend fun testNetworkId(`value`: Output<String>) {
        this.testNetworkId = value
    }

    /**
     * @param value The selected test subnet name.
     */
    @JvmName("kvqmeyewexbalnyt")
    public suspend fun testSubnetName(`value`: Output<String>) {
        this.testSubnetName = value
    }

    /**
     * @param value The ARM Id of the VM discovered in VMware.
     */
    @JvmName("tjjnpdxwekicwxxh")
    public suspend fun vmwareMachineId(`value`: Output<String>) {
        this.vmwareMachineId = value
    }

    /**
     * @param value The confidential VM key vault Id for ADE installation.
     */
    @JvmName("gbjnjiwvfctknhpw")
    public suspend fun confidentialVmKeyVaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialVmKeyVaultId = mapped
    }

    /**
     * @param value The data mover run as account Id.
     */
    @JvmName("ecsjdjgkpscxgjsk")
    public suspend fun dataMoverRunAsAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataMoverRunAsAccountId = mapped
    }

    /**
     * @param value The disks to include list.
     */
    @JvmName("etsqdbqyqitikvgq")
    public suspend fun disksToInclude(`value`: List<VMwareCbtDiskInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disksToInclude = mapped
    }

    /**
     * @param argument The disks to include list.
     */
    @JvmName("lkqahbfrtfkrrohc")
    public suspend
    fun disksToInclude(argument: List<suspend VMwareCbtDiskInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VMwareCbtDiskInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.disksToInclude = mapped
    }

    /**
     * @param argument The disks to include list.
     */
    @JvmName("jrybhfxhkluxdqlr")
    public suspend fun disksToInclude(
        vararg
        argument: suspend VMwareCbtDiskInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VMwareCbtDiskInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.disksToInclude = mapped
    }

    /**
     * @param argument The disks to include list.
     */
    @JvmName("pjkgmtuwexqcuknf")
    public suspend fun disksToInclude(argument: suspend VMwareCbtDiskInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VMwareCbtDiskInputArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.disksToInclude = mapped
    }

    /**
     * @param values The disks to include list.
     */
    @JvmName("nblvmkjupabmeyro")
    public suspend fun disksToInclude(vararg values: VMwareCbtDiskInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disksToInclude = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'VMwareCbt'.
     */
    @JvmName("anlfbmsuhqnneqxr")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value License type.
     */
    @JvmName("efxekuylrcvpiuuj")
    public suspend fun licenseType(`value`: Either<String, LicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value License type.
     */
    @JvmName("kqaojennkyydyxno")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value License type.
     */
    @JvmName("bnvqsuffruitgcwo")
    public fun licenseType(`value`: LicenseType) {
        val toBeMapped = Either.ofRight<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value A value indicating whether auto resync is to be done.
     */
    @JvmName("wfwsbngoobctwhws")
    public suspend fun performAutoResync(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performAutoResync = mapped
    }

    /**
     * @param value A value indicating whether bulk SQL RP registration to be done.
     */
    @JvmName("mmqbgoaksxsoplqo")
    public suspend fun performSqlBulkRegistration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performSqlBulkRegistration = mapped
    }

    /**
     * @param value The tags for the seed disks.
     */
    @JvmName("tcpqwdldhrblpjpx")
    public suspend fun seedDiskTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.seedDiskTags = mapped
    }

    /**
     * @param values The tags for the seed disks.
     */
    @JvmName("ailqpvxabxfkqsfw")
    public fun seedDiskTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.seedDiskTags = mapped
    }

    /**
     * @param value The snapshot run as account Id.
     */
    @JvmName("qcplayidsuinigaf")
    public suspend fun snapshotRunAsAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotRunAsAccountId = mapped
    }

    /**
     * @param value The SQL Server license type.
     */
    @JvmName("kljpwfdpvtbagsnk")
    public suspend fun sqlServerLicenseType(`value`: Either<String, SqlServerLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value The SQL Server license type.
     */
    @JvmName("rofpmbyiapeofkku")
    public fun sqlServerLicenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlServerLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value The SQL Server license type.
     */
    @JvmName("waskixufdlgjgaat")
    public fun sqlServerLicenseType(`value`: SqlServerLicenseType) {
        val toBeMapped = Either.ofRight<String, SqlServerLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value The target availability set ARM Id.
     */
    @JvmName("akbfmvvwxltpfctl")
    public suspend fun targetAvailabilitySetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAvailabilitySetId = mapped
    }

    /**
     * @param value The target availability zone.
     */
    @JvmName("mqwwjnmnsmgljdbp")
    public suspend fun targetAvailabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAvailabilityZone = mapped
    }

    /**
     * @param value The target boot diagnostics storage account ARM Id.
     */
    @JvmName("nckfbxosqicnkisa")
    public suspend fun targetBootDiagnosticsStorageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetBootDiagnosticsStorageAccountId = mapped
    }

    /**
     * @param value The tags for the target disks.
     */
    @JvmName("wvpyromimbtqhwgf")
    public suspend fun targetDiskTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDiskTags = mapped
    }

    /**
     * @param values The tags for the target disks.
     */
    @JvmName("jpdetmvuenjgddjc")
    public fun targetDiskTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetDiskTags = mapped
    }

    /**
     * @param value The target network ARM Id.
     */
    @JvmName("ktwsaqxkioctbkdb")
    public suspend fun targetNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetNetworkId = mapped
    }

    /**
     * @param value The tags for the target NICs.
     */
    @JvmName("xleabeovbpcmtpuq")
    public suspend fun targetNicTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNicTags = mapped
    }

    /**
     * @param values The tags for the target NICs.
     */
    @JvmName("yqdekolooklnynqq")
    public fun targetNicTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetNicTags = mapped
    }

    /**
     * @param value The target proximity placement group ARM Id.
     */
    @JvmName("nvkjsuitohkticle")
    public suspend fun targetProximityPlacementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetProximityPlacementGroupId = mapped
    }

    /**
     * @param value The target resource group ARM Id.
     */
    @JvmName("sergtncuencdnhul")
    public suspend fun targetResourceGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceGroupId = mapped
    }

    /**
     * @param value The target subnet name.
     */
    @JvmName("ojcxfxsxxxhupnsc")
    public suspend fun targetSubnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSubnetName = mapped
    }

    /**
     * @param value The target VM name.
     */
    @JvmName("qcndyypkbavfcgkb")
    public suspend fun targetVmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmName = mapped
    }

    /**
     * @param value The target VM security profile.
     */
    @JvmName("qbiytjvaxuhvyinq")
    public suspend fun targetVmSecurityProfile(`value`: VMwareCbtSecurityProfilePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmSecurityProfile = mapped
    }

    /**
     * @param argument The target VM security profile.
     */
    @JvmName("lyvtmiqvwqxbkkek")
    public suspend
    fun targetVmSecurityProfile(argument: suspend VMwareCbtSecurityProfilePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VMwareCbtSecurityProfilePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.targetVmSecurityProfile = mapped
    }

    /**
     * @param value The target VM size.
     */
    @JvmName("tmmyilmwqfstduuv")
    public suspend fun targetVmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmSize = mapped
    }

    /**
     * @param value The target VM tags.
     */
    @JvmName("bsqvlhceoolnolon")
    public suspend fun targetVmTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmTags = mapped
    }

    /**
     * @param values The target VM tags.
     */
    @JvmName("pjdgxbyojyxlijnj")
    public fun targetVmTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetVmTags = mapped
    }

    /**
     * @param value The selected test network ARM Id.
     */
    @JvmName("gxkhtuihgcjxiive")
    public suspend fun testNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testNetworkId = mapped
    }

    /**
     * @param value The selected test subnet name.
     */
    @JvmName("roflmffvijcpvqcj")
    public suspend fun testSubnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testSubnetName = mapped
    }

    /**
     * @param value The ARM Id of the VM discovered in VMware.
     */
    @JvmName("krifljncmbwqhovy")
    public suspend fun vmwareMachineId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmwareMachineId = mapped
    }

    internal fun build(): VMwareCbtEnableMigrationInputArgs = VMwareCbtEnableMigrationInputArgs(
        confidentialVmKeyVaultId = confidentialVmKeyVaultId,
        dataMoverRunAsAccountId = dataMoverRunAsAccountId ?: throw
            PulumiNullFieldException("dataMoverRunAsAccountId"),
        disksToInclude = disksToInclude ?: throw PulumiNullFieldException("disksToInclude"),
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        licenseType = licenseType,
        performAutoResync = performAutoResync,
        performSqlBulkRegistration = performSqlBulkRegistration,
        seedDiskTags = seedDiskTags,
        snapshotRunAsAccountId = snapshotRunAsAccountId ?: throw
            PulumiNullFieldException("snapshotRunAsAccountId"),
        sqlServerLicenseType = sqlServerLicenseType,
        targetAvailabilitySetId = targetAvailabilitySetId,
        targetAvailabilityZone = targetAvailabilityZone,
        targetBootDiagnosticsStorageAccountId = targetBootDiagnosticsStorageAccountId,
        targetDiskTags = targetDiskTags,
        targetNetworkId = targetNetworkId ?: throw PulumiNullFieldException("targetNetworkId"),
        targetNicTags = targetNicTags,
        targetProximityPlacementGroupId = targetProximityPlacementGroupId,
        targetResourceGroupId = targetResourceGroupId ?: throw
            PulumiNullFieldException("targetResourceGroupId"),
        targetSubnetName = targetSubnetName,
        targetVmName = targetVmName,
        targetVmSecurityProfile = targetVmSecurityProfile,
        targetVmSize = targetVmSize,
        targetVmTags = targetVmTags,
        testNetworkId = testNetworkId,
        testSubnetName = testSubnetName,
        vmwareMachineId = vmwareMachineId ?: throw PulumiNullFieldException("vmwareMachineId"),
    )
}
