@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.VmmToAzureCreateNetworkMappingInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Create network mappings input properties/behavior specific to Vmm to Azure Network mapping.
 * @property instanceType The instance type.
 * Expected value is 'VmmToAzure'.
 */
public data class VmmToAzureCreateNetworkMappingInputArgs(
    public val instanceType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.VmmToAzureCreateNetworkMappingInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.VmmToAzureCreateNetworkMappingInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.VmmToAzureCreateNetworkMappingInputArgs.builder()
            .instanceType(instanceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VmmToAzureCreateNetworkMappingInputArgs].
 */
@PulumiTagMarker
public class VmmToAzureCreateNetworkMappingInputArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    /**
     * @param value The instance type.
     * Expected value is 'VmmToAzure'.
     */
    @JvmName("ofkvrshblcehgjml")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The instance type.
     * Expected value is 'VmmToAzure'.
     */
    @JvmName("txrefaiosygaqfkn")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    internal fun build(): VmmToAzureCreateNetworkMappingInputArgs =
        VmmToAzureCreateNetworkMappingInputArgs(
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        )
}
