@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.VmmToVmmCreateNetworkMappingInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Create network mappings input properties/behavior specific to vmm to vmm Network mapping.
 * @property instanceType The instance type.
 * Expected value is 'VmmToVmm'.
 */
public data class VmmToVmmCreateNetworkMappingInputArgs(
    public val instanceType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.VmmToVmmCreateNetworkMappingInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.VmmToVmmCreateNetworkMappingInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.VmmToVmmCreateNetworkMappingInputArgs.builder()
            .instanceType(instanceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VmmToVmmCreateNetworkMappingInputArgs].
 */
@PulumiTagMarker
public class VmmToVmmCreateNetworkMappingInputArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    /**
     * @param value The instance type.
     * Expected value is 'VmmToVmm'.
     */
    @JvmName("kvclinklwghsprgo")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The instance type.
     * Expected value is 'VmmToVmm'.
     */
    @JvmName("whxrfrkljqhjjehj")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    internal fun build(): VmmToVmmCreateNetworkMappingInputArgs =
        VmmToVmmCreateNetworkMappingInputArgs(
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        )
}
