@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.WeeklyRetentionFormatArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.DayOfWeek
import com.pulumi.azurenative.recoveryservices.kotlin.enums.WeekOfMonth
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Weekly retention format.
 * @property daysOfTheWeek List of days of the week.
 * @property weeksOfTheMonth List of weeks of month.
 */
public data class WeeklyRetentionFormatArgs(
    public val daysOfTheWeek: Output<List<DayOfWeek>>? = null,
    public val weeksOfTheMonth: Output<List<WeekOfMonth>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.WeeklyRetentionFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.WeeklyRetentionFormatArgs =
        com.pulumi.azurenative.recoveryservices.inputs.WeeklyRetentionFormatArgs.builder()
            .daysOfTheWeek(
                daysOfTheWeek?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .weeksOfTheMonth(
                weeksOfTheMonth?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WeeklyRetentionFormatArgs].
 */
@PulumiTagMarker
public class WeeklyRetentionFormatArgsBuilder internal constructor() {
    private var daysOfTheWeek: Output<List<DayOfWeek>>? = null

    private var weeksOfTheMonth: Output<List<WeekOfMonth>>? = null

    /**
     * @param value List of days of the week.
     */
    @JvmName("lwgpyntrfudqgxck")
    public suspend fun daysOfTheWeek(`value`: Output<List<DayOfWeek>>) {
        this.daysOfTheWeek = value
    }

    @JvmName("wyjkhlfobssnuatn")
    public suspend fun daysOfTheWeek(vararg values: Output<DayOfWeek>) {
        this.daysOfTheWeek = Output.all(values.asList())
    }

    /**
     * @param values List of days of the week.
     */
    @JvmName("juxacbhsbynvjfob")
    public suspend fun daysOfTheWeek(values: List<Output<DayOfWeek>>) {
        this.daysOfTheWeek = Output.all(values)
    }

    /**
     * @param value List of weeks of month.
     */
    @JvmName("gjvcacaylbojmugi")
    public suspend fun weeksOfTheMonth(`value`: Output<List<WeekOfMonth>>) {
        this.weeksOfTheMonth = value
    }

    @JvmName("gpolpopiysdioqxn")
    public suspend fun weeksOfTheMonth(vararg values: Output<WeekOfMonth>) {
        this.weeksOfTheMonth = Output.all(values.asList())
    }

    /**
     * @param values List of weeks of month.
     */
    @JvmName("exhmiibnsgffylhf")
    public suspend fun weeksOfTheMonth(values: List<Output<WeekOfMonth>>) {
        this.weeksOfTheMonth = Output.all(values)
    }

    /**
     * @param value List of days of the week.
     */
    @JvmName("mlcxmoydsjdhhcnj")
    public suspend fun daysOfTheWeek(`value`: List<DayOfWeek>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysOfTheWeek = mapped
    }

    /**
     * @param values List of days of the week.
     */
    @JvmName("vfkuffmaavmivfpl")
    public suspend fun daysOfTheWeek(vararg values: DayOfWeek) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfTheWeek = mapped
    }

    /**
     * @param value List of weeks of month.
     */
    @JvmName("ppmhyhoseqstahih")
    public suspend fun weeksOfTheMonth(`value`: List<WeekOfMonth>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeksOfTheMonth = mapped
    }

    /**
     * @param values List of weeks of month.
     */
    @JvmName("ysucxblumxufbynk")
    public suspend fun weeksOfTheMonth(vararg values: WeekOfMonth) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weeksOfTheMonth = mapped
    }

    internal fun build(): WeeklyRetentionFormatArgs = WeeklyRetentionFormatArgs(
        daysOfTheWeek = daysOfTheWeek,
        weeksOfTheMonth = weeksOfTheMonth,
    )
}
